import datetime


def td_format(td_object: datetime.timedelta):
    """Generate user-friendly time duration"""

    seconds = int(td_object.total_seconds())

    if seconds == 0:
        return "less than 1 second"

    periods = [
        ('year', 60*60*24* 365 ) ,
        ('month',       60* 60* 24 * 30 ),
        ('day', 60 *60*24),
        ('hour',        60 *60),
        ('minute',      60),
        ('second',      1)
    ]
    strings= []
    for period_name, period_seconds in periods:
        if seconds >= period_seconds:
            period_value, seconds = divmod(seconds, period_seconds)
            if period_value == 1:
                strings.append("%s %s" % (period_value, period_name))
            else:
                strings.append("%s %ss" % (period_value, period_name))

    return ", ".join(strings)
