# ==============================================================================
# Copyright (C) 2019 - Philip Paquette
#
#  This program is free software: you can redistribute it and/or modify it under
#  the terms of the GNU Affero General Public License as published by the Free
#  Software Foundation, either version 3 of the License, or (at your option) any
#  later version.
#
#  This program is distributed in the hope that it will be useful, but WITHOUT
#  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
#  details.
#
#  You should have received a copy of the GNU Affero General Public License along
#  with this program.  If not, see <https://www.gnu.org/licenses/>.
# ==============================================================================
""" Tests the DAIDE tokens"""
from enum import Enum
from diplomacy.daide.tokens import Token

class ExpectedTokens(Enum):
    """ Copy of the tokens definition from aiclient/adjudicator/TOKENS.h """
    # Source: http://www.ellought.demon.co.uk/dipai/aiclient.zip
    # Powers
    TOKEN_POWER_AUS = 0x4100
    TOKEN_POWER_ENG = 0x4101
    TOKEN_POWER_FRA = 0x4102
    TOKEN_POWER_GER = 0x4103
    TOKEN_POWER_ITA = 0x4104
    TOKEN_POWER_RUS = 0x4105
    TOKEN_POWER_TUR = 0x4106

    # Units
    TOKEN_UNIT_AMY = 0x4200
    TOKEN_UNIT_FLT = 0x4201

    # Orders
    TOKEN_ORDER_CTO = 0x4320
    TOKEN_ORDER_CVY = 0x4321
    TOKEN_ORDER_HLD = 0x4322
    TOKEN_ORDER_MTO = 0x4323
    TOKEN_ORDER_SUP = 0x4324
    TOKEN_ORDER_VIA = 0x4325
    TOKEN_ORDER_DSB = 0x4340
    TOKEN_ORDER_RTO = 0x4341
    TOKEN_ORDER_BLD = 0x4380
    TOKEN_ORDER_REM = 0x4381
    TOKEN_ORDER_WVE = 0x4382

    # Order Note
    TOKEN_ORDER_NOTE_MBV = 0x4400
    TOKEN_ORDER_NOTE_BPR = 0x4401
    TOKEN_ORDER_NOTE_CST = 0x4402
    TOKEN_ORDER_NOTE_ESC = 0x4403
    TOKEN_ORDER_NOTE_FAR = 0x4404
    TOKEN_ORDER_NOTE_HSC = 0x4405
    TOKEN_ORDER_NOTE_NAS = 0x4406
    TOKEN_ORDER_NOTE_NMB = 0x4407
    TOKEN_ORDER_NOTE_NMR = 0x4408
    TOKEN_ORDER_NOTE_NRN = 0x4409
    TOKEN_ORDER_NOTE_NRS = 0x440A
    TOKEN_ORDER_NOTE_NSA = 0x440B
    TOKEN_ORDER_NOTE_NSC = 0x440C
    TOKEN_ORDER_NOTE_NSF = 0x440D
    TOKEN_ORDER_NOTE_NSP = 0x440E
    TOKEN_ORDER_NOTE_NSU = 0x4410
    TOKEN_ORDER_NOTE_NVR = 0x4411
    TOKEN_ORDER_NOTE_NYU = 0x4412
    TOKEN_ORDER_NOTE_YSC = 0x4413

    # Results
    TOKEN_RESULT_SUC = 0x4500
    TOKEN_RESULT_BNC = 0x4501
    TOKEN_RESULT_CUT = 0x4502
    TOKEN_RESULT_DSR = 0x4503
    TOKEN_RESULT_FLD = 0x4504
    TOKEN_RESULT_NSO = 0x4505
    TOKEN_RESULT_RET = 0x4506

    # Coasts
    TOKEN_COAST_NCS = 0x4600
    TOKEN_COAST_NEC = 0x4602
    TOKEN_COAST_ECS = 0x4604
    TOKEN_COAST_SEC = 0x4606
    TOKEN_COAST_SCS = 0x4608
    TOKEN_COAST_SWC = 0x460A
    TOKEN_COAST_WCS = 0x460C
    TOKEN_COAST_NWC = 0x460E

    # Seasons
    TOKEN_SEASON_SPR = 0x4700
    TOKEN_SEASON_SUM = 0x4701
    TOKEN_SEASON_FAL = 0x4702
    TOKEN_SEASON_AUT = 0x4703
    TOKEN_SEASON_WIN = 0x4704

    # Commands
    TOKEN_COMMAND_CCD = 0x4800
    TOKEN_COMMAND_DRW = 0x4801
    TOKEN_COMMAND_FRM = 0x4802
    TOKEN_COMMAND_GOF = 0x4803
    TOKEN_COMMAND_HLO = 0x4804
    TOKEN_COMMAND_HST = 0x4805
    TOKEN_COMMAND_HUH = 0x4806
    TOKEN_COMMAND_IAM = 0x4807
    TOKEN_COMMAND_LOD = 0x4808
    TOKEN_COMMAND_MAP = 0x4809
    TOKEN_COMMAND_MDF = 0x480A
    TOKEN_COMMAND_MIS = 0x480B
    TOKEN_COMMAND_NME = 0x480C
    TOKEN_COMMAND_NOT = 0x480D
    TOKEN_COMMAND_NOW = 0x480E
    TOKEN_COMMAND_OBS = 0x480F
    TOKEN_COMMAND_OFF = 0x4810
    TOKEN_COMMAND_ORD = 0x4811
    TOKEN_COMMAND_OUT = 0x4812
    TOKEN_COMMAND_PRN = 0x4813
    TOKEN_COMMAND_REJ = 0x4814
    TOKEN_COMMAND_SCO = 0x4815
    TOKEN_COMMAND_SLO = 0x4816
    TOKEN_COMMAND_SND = 0x4817
    TOKEN_COMMAND_SUB = 0x4818
    TOKEN_COMMAND_SVE = 0x4819
    TOKEN_COMMAND_THX = 0x481A
    TOKEN_COMMAND_TME = 0x481B
    TOKEN_COMMAND_YES = 0x481C
    TOKEN_COMMAND_ADM = 0x481D
    TOKEN_COMMAND_SMR = 0x481E

    # Parameters
    TOKEN_PARAMETER_AOA = 0x4900
    TOKEN_PARAMETER_BTL = 0x4901
    TOKEN_PARAMETER_ERR = 0x4902
    TOKEN_PARAMETER_LVL = 0x4903
    TOKEN_PARAMETER_MRT = 0x4904
    TOKEN_PARAMETER_MTL = 0x4905
    TOKEN_PARAMETER_NPB = 0x4906
    TOKEN_PARAMETER_NPR = 0x4907
    TOKEN_PARAMETER_PDA = 0x4908
    TOKEN_PARAMETER_PTL = 0x4909
    TOKEN_PARAMETER_RTL = 0x490A
    TOKEN_PARAMETER_UNO = 0x490B
    TOKEN_PARAMETER_DSD = 0x490D

    # Press
    TOKEN_PRESS_ALY = 0x4A00
    TOKEN_PRESS_AND = 0x4A01
    TOKEN_PRESS_BWX = 0x4A02
    TOKEN_PRESS_DMZ = 0x4A03
    TOKEN_PRESS_ELS = 0x4A04
    TOKEN_PRESS_EXP = 0x4A05
    TOKEN_PRESS_FCT = 0x4A06
    TOKEN_PRESS_FOR = 0x4A07
    TOKEN_PRESS_FWD = 0x4A08
    TOKEN_PRESS_HOW = 0x4A09
    TOKEN_PRESS_IDK = 0x4A0A
    TOKEN_PRESS_IFF = 0x4A0B
    TOKEN_PRESS_INS = 0x4A0C
    TOKEN_PRESS_OCC = 0x4A0E
    TOKEN_PRESS_ORR = 0x4A0F
    TOKEN_PRESS_PCE = 0x4A10
    TOKEN_PRESS_POB = 0x4A11
    TOKEN_PRESS_PRP = 0x4A13
    TOKEN_PRESS_QRY = 0x4A14
    TOKEN_PRESS_SCD = 0x4A15
    TOKEN_PRESS_SRY = 0x4A16
    TOKEN_PRESS_SUG = 0x4A17
    TOKEN_PRESS_THK = 0x4A18
    TOKEN_PRESS_THN = 0x4A19
    TOKEN_PRESS_TRY = 0x4A1A
    TOKEN_PRESS_VSS = 0x4A1C
    TOKEN_PRESS_WHT = 0x4A1D
    TOKEN_PRESS_WHY = 0x4A1E
    TOKEN_PRESS_XDO = 0x4A1F
    TOKEN_PRESS_XOY = 0x4A20
    TOKEN_PRESS_YDO = 0x4A21
    TOKEN_PRESS_CHO = 0x4A22
    TOKEN_PRESS_BCC = 0x4A23
    TOKEN_PRESS_UNT = 0x4A24

    # Provinces
    TOKEN_PROVINCE_BOH = 0x5000
    TOKEN_PROVINCE_BUR = 0x5001
    TOKEN_PROVINCE_GAL = 0x5002
    TOKEN_PROVINCE_RUH = 0x5003
    TOKEN_PROVINCE_SIL = 0x5004
    TOKEN_PROVINCE_TYR = 0x5005
    TOKEN_PROVINCE_UKR = 0x5006
    TOKEN_PROVINCE_BUD = 0x5107
    TOKEN_PROVINCE_MOS = 0x5108
    TOKEN_PROVINCE_MUN = 0x5109
    TOKEN_PROVINCE_PAR = 0x510A
    TOKEN_PROVINCE_SER = 0x510B
    TOKEN_PROVINCE_VIE = 0x510C
    TOKEN_PROVINCE_WAR = 0x510D
    TOKEN_PROVINCE_ADR = 0x520E
    TOKEN_PROVINCE_AEG = 0x520F
    TOKEN_PROVINCE_BAL = 0x5210
    TOKEN_PROVINCE_BAR = 0x5211
    TOKEN_PROVINCE_BLA = 0x5212
    TOKEN_PROVINCE_EAS = 0x5213
    TOKEN_PROVINCE_ECH = 0x5214
    TOKEN_PROVINCE_GOB = 0x5215
    TOKEN_PROVINCE_GOL = 0x5216
    TOKEN_PROVINCE_HEL = 0x5217
    TOKEN_PROVINCE_ION = 0x5218
    TOKEN_PROVINCE_IRI = 0x5219
    TOKEN_PROVINCE_MAO = 0x521A
    TOKEN_PROVINCE_NAO = 0x521B
    TOKEN_PROVINCE_NTH = 0x521C
    TOKEN_PROVINCE_NWG = 0x521D
    TOKEN_PROVINCE_SKA = 0x521E
    TOKEN_PROVINCE_TYS = 0x521F
    TOKEN_PROVINCE_WES = 0x5220
    TOKEN_PROVINCE_ALB = 0x5421
    TOKEN_PROVINCE_APU = 0x5422
    TOKEN_PROVINCE_ARM = 0x5423
    TOKEN_PROVINCE_CLY = 0x5424
    TOKEN_PROVINCE_FIN = 0x5425
    TOKEN_PROVINCE_GAS = 0x5426
    TOKEN_PROVINCE_LVN = 0x5427
    TOKEN_PROVINCE_NAF = 0x5428
    TOKEN_PROVINCE_PIC = 0x5429
    TOKEN_PROVINCE_PIE = 0x542A
    TOKEN_PROVINCE_PRU = 0x542B
    TOKEN_PROVINCE_SYR = 0x542C
    TOKEN_PROVINCE_TUS = 0x542D
    TOKEN_PROVINCE_WAL = 0x542E
    TOKEN_PROVINCE_YOR = 0x542F
    TOKEN_PROVINCE_ANK = 0x5530
    TOKEN_PROVINCE_BEL = 0x5531
    TOKEN_PROVINCE_BER = 0x5532
    TOKEN_PROVINCE_BRE = 0x5533
    TOKEN_PROVINCE_CON = 0x5534
    TOKEN_PROVINCE_DEN = 0x5535
    TOKEN_PROVINCE_EDI = 0x5536
    TOKEN_PROVINCE_GRE = 0x5537
    TOKEN_PROVINCE_HOL = 0x5538
    TOKEN_PROVINCE_KIE = 0x5539
    TOKEN_PROVINCE_LON = 0x553A
    TOKEN_PROVINCE_LVP = 0x553B
    TOKEN_PROVINCE_MAR = 0x553C
    TOKEN_PROVINCE_NAP = 0x553D
    TOKEN_PROVINCE_NWY = 0x553E
    TOKEN_PROVINCE_POR = 0x553F
    TOKEN_PROVINCE_ROM = 0x5540
    TOKEN_PROVINCE_RUM = 0x5541
    TOKEN_PROVINCE_SEV = 0x5542
    TOKEN_PROVINCE_SMY = 0x5543
    TOKEN_PROVINCE_SWE = 0x5544
    TOKEN_PROVINCE_TRI = 0x5545
    TOKEN_PROVINCE_TUN = 0x5546
    TOKEN_PROVINCE_VEN = 0x5547
    TOKEN_PROVINCE_BUL = 0x5748
    TOKEN_PROVINCE_SPA = 0x5749
    TOKEN_PROVINCE_STP = 0x574A

def test_tokens():
    """ Test all tokens """
    for token in ExpectedTokens:
        token_str = token.name[-3:]
        token_bytes = token.value.to_bytes(2, byteorder='big')
        token_from_str = Token(from_str=token_str)
        token_from_bytes = Token(from_bytes=token_bytes)
        assert str(token_from_str) == token_str
        assert str(token_from_bytes) == token_str
        assert bytes(token_from_str) == token_bytes
        assert bytes(token_from_bytes) == token_bytes
