// ==============================================================================
// Copyright (C) 2019 - Philip Paquette, Steven Bocco
//
//  This program is free software: you can redistribute it and/or modify it under
//  the terms of the GNU Affero General Public License as published by the Free
//  Software Foundation, either version 3 of the License, or (at your option) any
//  later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT
//  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
//  FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
//  details.
//
//  You should have received a copy of the GNU Affero General Public License along
//  with this program.  If not, see <https://www.gnu.org/licenses/>.
// ==============================================================================
/** Strings. **/
export const STRINGS = {
    ACTIVE: 'active',
    ADMIN: 'admin',
    CANCELED: 'canceled',
    CHANNEL: 'channel',
    COMPLETED: 'completed',
    DEMOTE: 'demote',
    DUMMY: 'dummy',
    ERROR: 'error',
    GAME: 'game',
    MASTER_TYPE: 'master_type',
    MODERATOR: 'moderator',
    OBSERVER: 'observer',
    OBSERVER_TYPE: 'observer_type',
    OK: 'ok',
    OMNISCIENT: 'omniscient',
    OMNISCIENT_TYPE: 'omniscient_type',
    PAUSED: 'paused',
    PHASE: 'phase',
    PROMOTE: 'promote',
    STATE: 'state',
    STATE_HISTORY: 'state_history',
    SYNCHRONIZE: 'synchronize',
    ALL_GAME_STATUSES: ['forming', 'active', 'paused', 'completed', 'canceled'],
    ALL_POWER_NAMES: ['AUSTRIA', 'ENGLAND', 'FRANCE', 'GERMANY', 'ITALY', 'RUSSIA', 'TURKEY'],
    RULES: [
        'ALWAYS_WAIT',
        'BUILD_ANY',
        'CD_DUMMIES',
        'CIVIL_DISORDER',
        'DIFFERENT_ADJUDICATION',
        'DONT_SKIP_PHASES',
        'HOLD_WIN',
        'IGNORE_ERRORS',
        'MULTIPLE_POWERS_PER_PLAYER',
        'NO_CHECK',
        'NO_DEADLINE',
        'NO_DIAS',
        'NO_OBSERVATIONS',
        'NO_PRESS',
        'POWER_CHOICE',
        'PROPOSE_DIAS',
        'PUBLIC_PRESS',
        'REAL_TIME',
        'SHARED_VICTORY',
        'SOLITAIRE',
        'START_MASTER',
    ],
    PUBLIC_RULES: [
        'ALWAYS_WAIT',
        'BUILD_ANY',
        'CD_DUMMIES',
        'CIVIL_DISORDER',
        'DONT_SKIP_PHASES',
        'HOLD_WIN',
        'IGNORE_ERRORS',
        'MULTIPLE_POWERS_PER_PLAYER',
        'NO_DEADLINE',
        'NO_DIAS',
        'NO_OBSERVATIONS',
        'NO_PRESS',
        'PROPOSE_DIAS',
        'PUBLIC_PRESS',
        'REAL_TIME',
        'SHARED_VICTORY',
        'SOLITAIRE',
        'START_MASTER',
    ]
};
