# Generated by Django 2.0.8 on 2020-04-23 10:08

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.SQUARELET_ORGANIZATION_MODEL),
        ('squarelet_auth_organizations', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Membership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('active', models.BooleanField(default=False, help_text='The user is currently working on behalf of this organization', verbose_name='active')),
                ('admin', models.BooleanField(default=False, help_text='The user is an administrator for this organization', verbose_name='admin')),
                ('organization', models.ForeignKey(help_text='An organization being linked to a user', on_delete=django.db.models.deletion.CASCADE, related_name='memberships', to=settings.SQUARELET_ORGANIZATION_MODEL, verbose_name='organization')),
                ('user', models.ForeignKey(help_text='A user being linked to an organization', on_delete=django.db.models.deletion.CASCADE, related_name='memberships', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
        ),
        migrations.CreateModel(
            name='Plan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='name')),
                ('slug', models.SlugField(max_length=255, unique=True, verbose_name='slug')),
            ],
        ),
        migrations.AddField(
            model_name='organization',
            name='plan',
            field=models.ForeignKey(help_text='The subscription type for this organization', null=True, on_delete=django.db.models.deletion.PROTECT, to='squarelet_auth_organizations.Plan', verbose_name='plan'),
        ),
        migrations.AddField(
            model_name='organization',
            name='users',
            field=models.ManyToManyField(help_text='The users who are members of this organization', related_name='organizations', through='squarelet_auth_organizations.Membership', to=settings.AUTH_USER_MODEL, verbose_name='users'),
        ),
        migrations.AlterUniqueTogether(
            name='membership',
            unique_together={('user', 'organization')},
        ),
    ]
