"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apigw = require("@aws-cdk/aws-apigateway");
class ApiEventSource {
    constructor(method, path, options) {
        this.method = method;
        this.path = path;
        this.options = options;
        if (!path.startsWith('/')) {
            throw new Error(`Path must start with "/": ${path}`);
        }
    }
    bind(target) {
        const id = 'ApiEventSourceA7A86A4F';
        let api = target.node.tryFindChild(id);
        if (!api) {
            api = new apigw.RestApi(target, id, {
                defaultIntegration: new apigw.LambdaIntegration(target),
            });
        }
        const resource = api.root.resourceForPath(this.path);
        resource.addMethod(this.method, undefined, this.options);
    }
}
exports.ApiEventSource = ApiEventSource;
//# sourceMappingURL=data:application/json;base64,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