"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dynamodb = require("@aws-cdk/aws-dynamodb");
const lambda = require("@aws-cdk/aws-lambda");
/**
 * Use an Amazon DynamoDB stream as an event source for AWS Lambda.
 */
class DynamoEventSource {
    constructor(table, props) {
        this.table = table;
        this.props = props;
        if (this.props.batchSize !== undefined && (this.props.batchSize < 1 || this.props.batchSize > 1000)) {
            throw new Error(`Maximum batch size must be between 1 and 1000 inclusive (given ${this.props.batchSize})`);
        }
    }
    bind(target) {
        new lambda.EventSourceMapping(target, `DynamoDBEventSource:${this.table.node.uniqueId}`, {
            target,
            batchSize: this.props.batchSize || 100,
            eventSourceArn: this.table.tableStreamArn,
            startingPosition: this.props.startingPosition
        });
        this.table.grantStreamRead(target.role);
        dynamodb.Table.grantListStreams(target.role);
    }
}
exports.DynamoEventSource = DynamoEventSource;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZHluYW1vZGIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJkeW5hbW9kYi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLGtEQUFtRDtBQUNuRCw4Q0FBK0M7QUFvQi9DOztHQUVHO0FBQ0gsTUFBYSxpQkFBaUI7SUFDNUIsWUFBNkIsS0FBcUIsRUFBbUIsS0FBNkI7UUFBckUsVUFBSyxHQUFMLEtBQUssQ0FBZ0I7UUFBbUIsVUFBSyxHQUFMLEtBQUssQ0FBd0I7UUFDaEcsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsS0FBSyxTQUFTLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsR0FBRyxDQUFDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLEVBQUU7WUFDbkcsTUFBTSxJQUFJLEtBQUssQ0FBQyxrRUFBa0UsSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLEdBQUcsQ0FBQyxDQUFDO1NBQzVHO0lBQ0gsQ0FBQztJQUVNLElBQUksQ0FBQyxNQUEyQjtRQUNyQyxJQUFJLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLEVBQUUsdUJBQXVCLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxFQUFFO1lBQ3ZGLE1BQU07WUFDTixTQUFTLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLElBQUksR0FBRztZQUN0QyxjQUFjLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjO1lBQ3pDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCO1NBQzlDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN4QyxRQUFRLENBQUMsS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUMvQyxDQUFDO0NBQ0Y7QUFsQkQsOENBa0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGR5bmFtb2RiID0gcmVxdWlyZSgnQGF3cy1jZGsvYXdzLWR5bmFtb2RiJyk7XG5pbXBvcnQgbGFtYmRhID0gcmVxdWlyZSgnQGF3cy1jZGsvYXdzLWxhbWJkYScpO1xuXG5leHBvcnQgaW50ZXJmYWNlIER5bmFtb0V2ZW50U291cmNlUHJvcHMge1xuICAvKipcbiAgICogVGhlIGxhcmdlc3QgbnVtYmVyIG9mIHJlY29yZHMgdGhhdCBBV1MgTGFtYmRhIHdpbGwgcmV0cmlldmUgZnJvbSB5b3VyIGV2ZW50XG4gICAqIHNvdXJjZSBhdCB0aGUgdGltZSBvZiBpbnZva2luZyB5b3VyIGZ1bmN0aW9uLiBZb3VyIGZ1bmN0aW9uIHJlY2VpdmVzIGFuXG4gICAqIGV2ZW50IHdpdGggYWxsIHRoZSByZXRyaWV2ZWQgcmVjb3Jkcy5cbiAgICpcbiAgICogVmFsaWQgUmFuZ2U6IE1pbmltdW0gdmFsdWUgb2YgMS4gTWF4aW11bSB2YWx1ZSBvZiAxMDAwLlxuICAgKlxuICAgKiBAZGVmYXVsdCAxMDBcbiAgICovXG4gIHJlYWRvbmx5IGJhdGNoU2l6ZT86IG51bWJlcjtcblxuICAvKipcbiAgICogV2hlcmUgdG8gYmVnaW4gY29uc3VtaW5nIHRoZSBEeW5hbW9EQiBzdHJlYW0uXG4gICAqL1xuICByZWFkb25seSBzdGFydGluZ1Bvc2l0aW9uOiBsYW1iZGEuU3RhcnRpbmdQb3NpdGlvbjtcbn1cblxuLyoqXG4gKiBVc2UgYW4gQW1hem9uIER5bmFtb0RCIHN0cmVhbSBhcyBhbiBldmVudCBzb3VyY2UgZm9yIEFXUyBMYW1iZGEuXG4gKi9cbmV4cG9ydCBjbGFzcyBEeW5hbW9FdmVudFNvdXJjZSBpbXBsZW1lbnRzIGxhbWJkYS5JRXZlbnRTb3VyY2Uge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHRhYmxlOiBkeW5hbW9kYi5UYWJsZSwgcHJpdmF0ZSByZWFkb25seSBwcm9wczogRHluYW1vRXZlbnRTb3VyY2VQcm9wcykge1xuICAgIGlmICh0aGlzLnByb3BzLmJhdGNoU2l6ZSAhPT0gdW5kZWZpbmVkICYmICh0aGlzLnByb3BzLmJhdGNoU2l6ZSA8IDEgfHwgdGhpcy5wcm9wcy5iYXRjaFNpemUgPiAxMDAwKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBNYXhpbXVtIGJhdGNoIHNpemUgbXVzdCBiZSBiZXR3ZWVuIDEgYW5kIDEwMDAgaW5jbHVzaXZlIChnaXZlbiAke3RoaXMucHJvcHMuYmF0Y2hTaXplfSlgKTtcbiAgICB9XG4gIH1cblxuICBwdWJsaWMgYmluZCh0YXJnZXQ6IGxhbWJkYS5GdW5jdGlvbkJhc2UpIHtcbiAgICBuZXcgbGFtYmRhLkV2ZW50U291cmNlTWFwcGluZyh0YXJnZXQsIGBEeW5hbW9EQkV2ZW50U291cmNlOiR7dGhpcy50YWJsZS5ub2RlLnVuaXF1ZUlkfWAsIHtcbiAgICAgIHRhcmdldCxcbiAgICAgIGJhdGNoU2l6ZTogdGhpcy5wcm9wcy5iYXRjaFNpemUgfHwgMTAwLFxuICAgICAgZXZlbnRTb3VyY2VBcm46IHRoaXMudGFibGUudGFibGVTdHJlYW1Bcm4sXG4gICAgICBzdGFydGluZ1Bvc2l0aW9uOiB0aGlzLnByb3BzLnN0YXJ0aW5nUG9zaXRpb25cbiAgICB9KTtcblxuICAgIHRoaXMudGFibGUuZ3JhbnRTdHJlYW1SZWFkKHRhcmdldC5yb2xlKTtcbiAgICBkeW5hbW9kYi5UYWJsZS5ncmFudExpc3RTdHJlYW1zKHRhcmdldC5yb2xlKTtcbiAgfVxufVxuIl19