"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Use S3 bucket notifications as an event source for AWS Lambda.
 */
class S3EventSource {
    constructor(bucket, props) {
        this.bucket = bucket;
        this.props = props;
    }
    bind(target) {
        const filters = this.props.filters || [];
        for (const event of this.props.events) {
            this.bucket.onEvent(event, target, ...filters);
        }
    }
}
exports.S3EventSource = S3EventSource;
//# sourceMappingURL=data:application/json;base64,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