"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const kinesis = require("@aws-cdk/aws-kinesis");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const test_function_1 = require("./test-function");
class KinesisEventSourceTest extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const fn = new test_function_1.TestFunction(this, 'F');
        const stream = new kinesis.Stream(this, 'Q');
        fn.addEventSource(new lib_1.KinesisEventSource(stream, {
            startingPosition: lambda.StartingPosition.TrimHorizon
        }));
    }
}
const app = new cdk.App();
new KinesisEventSourceTest(app, 'lambda-event-source-kinesis');
app.run();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcua2luZXNpcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLmtpbmVzaXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnREFBaUQ7QUFDakQsOENBQStDO0FBQy9DLG9DQUFxQztBQUNyQyxnQ0FBNEM7QUFDNUMsbURBQStDO0FBRS9DLE1BQU0sc0JBQXVCLFNBQVEsR0FBRyxDQUFDLEtBQUs7SUFDNUMsWUFBWSxLQUFjLEVBQUUsRUFBVTtRQUNwQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sRUFBRSxHQUFHLElBQUksNEJBQVksQ0FBQyxJQUFJLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDdkMsTUFBTSxNQUFNLEdBQUcsSUFBSSxPQUFPLENBQUMsTUFBTSxDQUFDLElBQUksRUFBRSxHQUFHLENBQUMsQ0FBQztRQUU3QyxFQUFFLENBQUMsY0FBYyxDQUFDLElBQUksd0JBQWtCLENBQUMsTUFBTSxFQUFFO1lBQy9DLGdCQUFnQixFQUFFLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXO1NBQ3RELENBQUMsQ0FBQyxDQUFDO0lBQ04sQ0FBQztDQUNGO0FBRUQsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsSUFBSSxzQkFBc0IsQ0FBQyxHQUFHLEVBQUUsNkJBQTZCLENBQUMsQ0FBQztBQUMvRCxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQga2luZXNpcyA9IHJlcXVpcmUoJ0Bhd3MtY2RrL2F3cy1raW5lc2lzJyk7XG5pbXBvcnQgbGFtYmRhID0gcmVxdWlyZSgnQGF3cy1jZGsvYXdzLWxhbWJkYScpO1xuaW1wb3J0IGNkayA9IHJlcXVpcmUoJ0Bhd3MtY2RrL2NkaycpO1xuaW1wb3J0IHsgS2luZXNpc0V2ZW50U291cmNlIH0gZnJvbSAnLi4vbGliJztcbmltcG9ydCB7IFRlc3RGdW5jdGlvbiB9IGZyb20gJy4vdGVzdC1mdW5jdGlvbic7XG5cbmNsYXNzIEtpbmVzaXNFdmVudFNvdXJjZVRlc3QgZXh0ZW5kcyBjZGsuU3RhY2sge1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkFwcCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBmbiA9IG5ldyBUZXN0RnVuY3Rpb24odGhpcywgJ0YnKTtcbiAgICBjb25zdCBzdHJlYW0gPSBuZXcga2luZXNpcy5TdHJlYW0odGhpcywgJ1EnKTtcblxuICAgIGZuLmFkZEV2ZW50U291cmNlKG5ldyBLaW5lc2lzRXZlbnRTb3VyY2Uoc3RyZWFtLCB7XG4gICAgICBzdGFydGluZ1Bvc2l0aW9uOiBsYW1iZGEuU3RhcnRpbmdQb3NpdGlvbi5UcmltSG9yaXpvblxuICAgIH0pKTtcbiAgfVxufVxuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xubmV3IEtpbmVzaXNFdmVudFNvdXJjZVRlc3QoYXBwLCAnbGFtYmRhLWV2ZW50LXNvdXJjZS1raW5lc2lzJyk7XG5hcHAucnVuKCk7Il19