"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const test_function_1 = require("./test-function");
class S3EventSourceTest extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const fn = new test_function_1.TestFunction(this, 'F');
        const bucket = new s3.Bucket(this, 'B', {
            removalPolicy: cdk.RemovalPolicy.Destroy
        });
        fn.addEventSource(new lib_1.S3EventSource(bucket, {
            events: [s3.EventType.ObjectCreated],
            filters: [{ prefix: 'subdir/' }]
        }));
    }
}
const app = new cdk.App();
new S3EventSourceTest(app, 'lambda-event-source-s3');
app.run();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuczMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5zMy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHNDQUF1QztBQUN2QyxvQ0FBcUM7QUFDckMsZ0NBQXVDO0FBQ3ZDLG1EQUErQztBQUUvQyxNQUFNLGlCQUFrQixTQUFRLEdBQUcsQ0FBQyxLQUFLO0lBQ3ZDLFlBQVksS0FBYyxFQUFFLEVBQVU7UUFDcEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEVBQUUsR0FBRyxJQUFJLDRCQUFZLENBQUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQ3ZDLE1BQU0sTUFBTSxHQUFHLElBQUksRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsR0FBRyxFQUFFO1lBQ3RDLGFBQWEsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLE9BQU87U0FDekMsQ0FBQyxDQUFDO1FBRUgsRUFBRSxDQUFDLGNBQWMsQ0FBQyxJQUFJLG1CQUFhLENBQUMsTUFBTSxFQUFFO1lBQzFDLE1BQU0sRUFBRSxDQUFFLEVBQUUsQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFFO1lBQ3RDLE9BQU8sRUFBRSxDQUFFLEVBQUUsTUFBTSxFQUFFLFNBQVMsRUFBRSxDQUFFO1NBQ25DLENBQUMsQ0FBQyxDQUFDO0lBQ04sQ0FBQztDQUNGO0FBRUQsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsSUFBSSxpQkFBaUIsQ0FBQyxHQUFHLEVBQUUsd0JBQXdCLENBQUMsQ0FBQztBQUNyRCxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgczMgPSByZXF1aXJlKCdAYXdzLWNkay9hd3MtczMnKTtcbmltcG9ydCBjZGsgPSByZXF1aXJlKCdAYXdzLWNkay9jZGsnKTtcbmltcG9ydCB7IFMzRXZlbnRTb3VyY2UgfSBmcm9tICcuLi9saWInO1xuaW1wb3J0IHsgVGVzdEZ1bmN0aW9uIH0gZnJvbSAnLi90ZXN0LWZ1bmN0aW9uJztcblxuY2xhc3MgUzNFdmVudFNvdXJjZVRlc3QgZXh0ZW5kcyBjZGsuU3RhY2sge1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkFwcCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBmbiA9IG5ldyBUZXN0RnVuY3Rpb24odGhpcywgJ0YnKTtcbiAgICBjb25zdCBidWNrZXQgPSBuZXcgczMuQnVja2V0KHRoaXMsICdCJywge1xuICAgICAgcmVtb3ZhbFBvbGljeTogY2RrLlJlbW92YWxQb2xpY3kuRGVzdHJveVxuICAgIH0pO1xuXG4gICAgZm4uYWRkRXZlbnRTb3VyY2UobmV3IFMzRXZlbnRTb3VyY2UoYnVja2V0LCB7XG4gICAgICBldmVudHM6IFsgczMuRXZlbnRUeXBlLk9iamVjdENyZWF0ZWQgXSxcbiAgICAgIGZpbHRlcnM6IFsgeyBwcmVmaXg6ICdzdWJkaXIvJyB9IF1cbiAgICB9KSk7XG4gIH1cbn1cblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcbm5ldyBTM0V2ZW50U291cmNlVGVzdChhcHAsICdsYW1iZGEtZXZlbnQtc291cmNlLXMzJyk7XG5hcHAucnVuKCk7XG4iXX0=