"use strict";
const assert_1 = require("@aws-cdk/assert");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/cdk");
const events = require("../lib");
module.exports = {
    'minimal example'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const handler = new lambda.Function(stack, 'MyFunc', {
            code: lambda.Code.inline('boom'),
            handler: 'index.handler',
            runtime: lambda.Runtime.NodeJS,
        });
        // WHEN
        handler.addEventSource(new events.ApiEventSource('get', '/foo'));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Resource', {
            PathPart: "foo",
            ParentId: { "Fn::GetAtt": ["MyFuncApiEventSourceA7A86A4FF4B434AC", "RootResourceId"] }
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Method', {
            HttpMethod: 'GET',
            ResourceId: { Ref: "MyFuncApiEventSourceA7A86A4Ffoo73254F28" },
        }));
        test.done();
    },
    'disjoint routes'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const handler = new lambda.Function(stack, 'MyFunc', {
            code: lambda.Code.inline('boom'),
            handler: 'index.handler',
            runtime: lambda.Runtime.NodeJS,
        });
        // WHEN
        handler.addEventSource(new events.ApiEventSource('get', '/foo'));
        handler.addEventSource(new events.ApiEventSource('post', '/bar'));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Resource', {
            PathPart: "foo",
            ParentId: { "Fn::GetAtt": ["MyFuncApiEventSourceA7A86A4FF4B434AC", "RootResourceId"] }
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Resource', {
            PathPart: "bar",
            ParentId: { "Fn::GetAtt": ["MyFuncApiEventSourceA7A86A4FF4B434AC", "RootResourceId"] }
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Method', {
            HttpMethod: 'GET',
            ResourceId: { Ref: "MyFuncApiEventSourceA7A86A4Ffoo73254F28" },
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Method', {
            HttpMethod: 'POST',
            ResourceId: { Ref: "MyFuncApiEventSourceA7A86A4FbarFF0EF497" },
        }));
        test.done();
    },
    "tree of routes"(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const handler = new lambda.Function(stack, 'MyFunc', {
            code: lambda.Code.inline('boom'),
            handler: 'index.handler',
            runtime: lambda.Runtime.NodeJS,
        });
        // WHEN
        handler.addEventSource(new events.ApiEventSource('get', '/foo'));
        handler.addEventSource(new events.ApiEventSource('post', '/foo/bar'));
        handler.addEventSource(new events.ApiEventSource('post', '/foo/bar/zoo'));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Resource', {
            PathPart: "foo",
            ParentId: { "Fn::GetAtt": ["MyFuncApiEventSourceA7A86A4FF4B434AC", "RootResourceId"] }
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Resource', {
            PathPart: "bar",
            ParentId: { Ref: "MyFuncApiEventSourceA7A86A4Ffoo73254F28" }
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Method', {
            HttpMethod: 'GET',
            ResourceId: { Ref: "MyFuncApiEventSourceA7A86A4Ffoo73254F28" },
        }));
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApiGateway::Method', {
            HttpMethod: 'POST',
            ResourceId: { Ref: "MyFuncApiEventSourceA7A86A4Ffoobarzoo34214ADE" },
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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