"use strict";
const assert_1 = require("@aws-cdk/assert");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/cdk");
const sources = require("../lib");
const test_function_1 = require("./test-function");
module.exports = {
    'sufficiently complex example'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const fn = new test_function_1.TestFunction(stack, 'Fn');
        const bucket = new s3.Bucket(stack, 'B');
        // WHEN
        fn.addEventSource(new sources.S3EventSource(bucket, {
            events: [s3.EventType.ObjectCreated, s3.EventType.ObjectRemoved],
            filters: [
                { prefix: 'prefix/' },
                { suffix: '.png' }
            ]
        }));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('Custom::S3BucketNotifications', {
            "NotificationConfiguration": {
                "LambdaFunctionConfigurations": [
                    {
                        "Events": [
                            "s3:ObjectCreated:*"
                        ],
                        "Filter": {
                            "Key": {
                                "FilterRules": [
                                    {
                                        "Name": "prefix",
                                        "Value": "prefix/"
                                    },
                                    {
                                        "Name": "suffix",
                                        "Value": ".png"
                                    }
                                ]
                            }
                        },
                        "LambdaFunctionArn": {
                            "Fn::GetAtt": [
                                "Fn9270CBC0",
                                "Arn"
                            ]
                        }
                    },
                    {
                        "Events": [
                            "s3:ObjectRemoved:*"
                        ],
                        "Filter": {
                            "Key": {
                                "FilterRules": [
                                    {
                                        "Name": "prefix",
                                        "Value": "prefix/"
                                    },
                                    {
                                        "Name": "suffix",
                                        "Value": ".png"
                                    }
                                ]
                            }
                        },
                        "LambdaFunctionArn": {
                            "Fn::GetAtt": [
                                "Fn9270CBC0",
                                "Arn"
                            ]
                        }
                    }
                ]
            }
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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