# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetSparkVersionResult',
    'AwaitableGetSparkVersionResult',
    'get_spark_version',
    'get_spark_version_output',
]

@pulumi.output_type
class GetSparkVersionResult:
    """
    A collection of values returned by getSparkVersion.
    """
    def __init__(__self__, beta=None, genomics=None, gpu=None, graviton=None, id=None, latest=None, long_term_support=None, ml=None, photon=None, scala=None, spark_version=None):
        if beta and not isinstance(beta, bool):
            raise TypeError("Expected argument 'beta' to be a bool")
        pulumi.set(__self__, "beta", beta)
        if genomics and not isinstance(genomics, bool):
            raise TypeError("Expected argument 'genomics' to be a bool")
        pulumi.set(__self__, "genomics", genomics)
        if gpu and not isinstance(gpu, bool):
            raise TypeError("Expected argument 'gpu' to be a bool")
        pulumi.set(__self__, "gpu", gpu)
        if graviton and not isinstance(graviton, bool):
            raise TypeError("Expected argument 'graviton' to be a bool")
        pulumi.set(__self__, "graviton", graviton)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latest and not isinstance(latest, bool):
            raise TypeError("Expected argument 'latest' to be a bool")
        pulumi.set(__self__, "latest", latest)
        if long_term_support and not isinstance(long_term_support, bool):
            raise TypeError("Expected argument 'long_term_support' to be a bool")
        pulumi.set(__self__, "long_term_support", long_term_support)
        if ml and not isinstance(ml, bool):
            raise TypeError("Expected argument 'ml' to be a bool")
        pulumi.set(__self__, "ml", ml)
        if photon and not isinstance(photon, bool):
            raise TypeError("Expected argument 'photon' to be a bool")
        pulumi.set(__self__, "photon", photon)
        if scala and not isinstance(scala, str):
            raise TypeError("Expected argument 'scala' to be a str")
        pulumi.set(__self__, "scala", scala)
        if spark_version and not isinstance(spark_version, str):
            raise TypeError("Expected argument 'spark_version' to be a str")
        pulumi.set(__self__, "spark_version", spark_version)

    @property
    @pulumi.getter
    def beta(self) -> Optional[bool]:
        return pulumi.get(self, "beta")

    @property
    @pulumi.getter
    def genomics(self) -> Optional[bool]:
        return pulumi.get(self, "genomics")

    @property
    @pulumi.getter
    def gpu(self) -> Optional[bool]:
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter
    def graviton(self) -> Optional[bool]:
        return pulumi.get(self, "graviton")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def latest(self) -> Optional[bool]:
        return pulumi.get(self, "latest")

    @property
    @pulumi.getter(name="longTermSupport")
    def long_term_support(self) -> Optional[bool]:
        return pulumi.get(self, "long_term_support")

    @property
    @pulumi.getter
    def ml(self) -> Optional[bool]:
        return pulumi.get(self, "ml")

    @property
    @pulumi.getter
    def photon(self) -> Optional[bool]:
        return pulumi.get(self, "photon")

    @property
    @pulumi.getter
    def scala(self) -> Optional[str]:
        return pulumi.get(self, "scala")

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[str]:
        return pulumi.get(self, "spark_version")


class AwaitableGetSparkVersionResult(GetSparkVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSparkVersionResult(
            beta=self.beta,
            genomics=self.genomics,
            gpu=self.gpu,
            graviton=self.graviton,
            id=self.id,
            latest=self.latest,
            long_term_support=self.long_term_support,
            ml=self.ml,
            photon=self.photon,
            scala=self.scala,
            spark_version=self.spark_version)


def get_spark_version(beta: Optional[bool] = None,
                      genomics: Optional[bool] = None,
                      gpu: Optional[bool] = None,
                      graviton: Optional[bool] = None,
                      latest: Optional[bool] = None,
                      long_term_support: Optional[bool] = None,
                      ml: Optional[bool] = None,
                      photon: Optional[bool] = None,
                      scala: Optional[str] = None,
                      spark_version: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSparkVersionResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    with_gpu = databricks.get_node_type(local_disk=True,
        min_cores=16,
        gb_per_core=1,
        min_gpus=1)
    gpu_ml = databricks.get_spark_version(gpu=True,
        ml=True)
    research = databricks.Cluster("research",
        cluster_name="Research Cluster",
        spark_version=gpu_ml.id,
        node_type_id=with_gpu.id,
        autotermination_minutes=20,
        autoscale=databricks.ClusterAutoscaleArgs(
            min_workers=1,
            max_workers=50,
        ))
    ```
    ## Related Resources

    The following resources are used in the same context:

    * End to end workspace management guide
    * Cluster to create [Databricks Clusters](https://docs.databricks.com/clusters/index.html).
    * ClusterPolicy to create a Cluster policy, which limits the ability to create clusters based on a set of rules.
    * InstancePool to manage [instance pools](https://docs.databricks.com/clusters/instance-pools/index.html) to reduce cluster start and auto-scaling times by maintaining a set of idle, ready-to-use instances.
    * Job to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code in a databricks_cluster.


    :param bool beta: if we should limit the search only to runtimes that are in Beta stage. Default to `false`.
    :param bool genomics: if we should limit the search only to Genomics (HLS) runtimes. Default to `false`.
    :param bool gpu: if we should limit the search only to runtimes that support GPUs. Default to `false`.
    :param bool graviton: if we should limit the search only to runtimes supporting AWS Graviton CPUs. Default to `false`.
    :param bool latest: if we should return only the latest version if there is more than one result.  Default to `true`. If set to `false` and multiple versions are matching, throws an error.
    :param bool long_term_support: if we should limit the search only to LTS (long term support) & ESR (extended support) versions. Default to `false`.
    :param bool ml: if we should limit the search only to ML runtimes. Default to `false`.
    :param bool photon: if we should limit the search only to Photon runtimes. Default to `false`.
    :param str scala: if we should limit the search only to runtimes that are based on specific Scala version. Default to `2.12`.
    :param str spark_version: if we should limit the search only to runtimes that are based on specific Spark version. Default to empty string.  It could be specified as `3`, or `3.0`, or full version, like, `3.0.1`.
    """
    __args__ = dict()
    __args__['beta'] = beta
    __args__['genomics'] = genomics
    __args__['gpu'] = gpu
    __args__['graviton'] = graviton
    __args__['latest'] = latest
    __args__['longTermSupport'] = long_term_support
    __args__['ml'] = ml
    __args__['photon'] = photon
    __args__['scala'] = scala
    __args__['sparkVersion'] = spark_version
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('databricks:index/getSparkVersion:getSparkVersion', __args__, opts=opts, typ=GetSparkVersionResult).value

    return AwaitableGetSparkVersionResult(
        beta=__ret__.beta,
        genomics=__ret__.genomics,
        gpu=__ret__.gpu,
        graviton=__ret__.graviton,
        id=__ret__.id,
        latest=__ret__.latest,
        long_term_support=__ret__.long_term_support,
        ml=__ret__.ml,
        photon=__ret__.photon,
        scala=__ret__.scala,
        spark_version=__ret__.spark_version)


@_utilities.lift_output_func(get_spark_version)
def get_spark_version_output(beta: Optional[pulumi.Input[Optional[bool]]] = None,
                             genomics: Optional[pulumi.Input[Optional[bool]]] = None,
                             gpu: Optional[pulumi.Input[Optional[bool]]] = None,
                             graviton: Optional[pulumi.Input[Optional[bool]]] = None,
                             latest: Optional[pulumi.Input[Optional[bool]]] = None,
                             long_term_support: Optional[pulumi.Input[Optional[bool]]] = None,
                             ml: Optional[pulumi.Input[Optional[bool]]] = None,
                             photon: Optional[pulumi.Input[Optional[bool]]] = None,
                             scala: Optional[pulumi.Input[Optional[str]]] = None,
                             spark_version: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSparkVersionResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    with_gpu = databricks.get_node_type(local_disk=True,
        min_cores=16,
        gb_per_core=1,
        min_gpus=1)
    gpu_ml = databricks.get_spark_version(gpu=True,
        ml=True)
    research = databricks.Cluster("research",
        cluster_name="Research Cluster",
        spark_version=gpu_ml.id,
        node_type_id=with_gpu.id,
        autotermination_minutes=20,
        autoscale=databricks.ClusterAutoscaleArgs(
            min_workers=1,
            max_workers=50,
        ))
    ```
    ## Related Resources

    The following resources are used in the same context:

    * End to end workspace management guide
    * Cluster to create [Databricks Clusters](https://docs.databricks.com/clusters/index.html).
    * ClusterPolicy to create a Cluster policy, which limits the ability to create clusters based on a set of rules.
    * InstancePool to manage [instance pools](https://docs.databricks.com/clusters/instance-pools/index.html) to reduce cluster start and auto-scaling times by maintaining a set of idle, ready-to-use instances.
    * Job to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code in a databricks_cluster.


    :param bool beta: if we should limit the search only to runtimes that are in Beta stage. Default to `false`.
    :param bool genomics: if we should limit the search only to Genomics (HLS) runtimes. Default to `false`.
    :param bool gpu: if we should limit the search only to runtimes that support GPUs. Default to `false`.
    :param bool graviton: if we should limit the search only to runtimes supporting AWS Graviton CPUs. Default to `false`.
    :param bool latest: if we should return only the latest version if there is more than one result.  Default to `true`. If set to `false` and multiple versions are matching, throws an error.
    :param bool long_term_support: if we should limit the search only to LTS (long term support) & ESR (extended support) versions. Default to `false`.
    :param bool ml: if we should limit the search only to ML runtimes. Default to `false`.
    :param bool photon: if we should limit the search only to Photon runtimes. Default to `false`.
    :param str scala: if we should limit the search only to runtimes that are based on specific Scala version. Default to `2.12`.
    :param str spark_version: if we should limit the search only to runtimes that are based on specific Spark version. Default to empty string.  It could be specified as `3`, or `3.0`, or full version, like, `3.0.1`.
    """
    ...
