"""Added journey table

Revision ID: f2fc2726507f
Revises: 689f13ef5c86
Create Date: 2021-10-11 21:23:19.926318

"""
from alembic import op
import sqlalchemy as sa

from vwsfriend.model.datetime_decorator import DatetimeDecorator

# revision identifiers, used by Alembic.
revision = 'f2fc2726507f'
down_revision = '689f13ef5c86'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('journey',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('vehicle_vin', sa.String(), nullable=True),
                    sa.Column('start', DatetimeDecorator(timezone=True), nullable=False),
                    sa.Column('end', DatetimeDecorator(timezone=True), nullable=False),
                    sa.Column('title', sa.String(), nullable=True),
                    sa.Column('description', sa.String(), nullable=True),
                    sa.ForeignKeyConstraint(['vehicle_vin'], ['vehicles.vin'], ),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('vehicle_vin', 'start')
                    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('journey')
    # ### end Alembic commands ###
