# Spectre


## Overview
CLI tool for generating code and config from generic, language-agnostic data model specifications based on JSON.
All spectre related files should be in a subdirectory called `spectre` in your project dir. This will also be where generated files appear.

See the [Generators](#generators) section for more information about what is possible to generate.

You can run `spectre generate` without arguments to learn the possible commands and options.

## Quickstart

Begin with creating an entity. This can be done in several ways

1. Writing a .spec file manually
2. From the interactive wizard in the CLI: `spectre create entity`
3. [Importing](#importing) a MySQL table description

This file can then be used to generate code and other artifacts. This is done with commands of the format `spectre generate artifactType pathToSpec --someOption`.

Example:

`spectre generate java --all MyEntity.spec`

## Entities

The core of Spectre is the `entity` concept. An entity is something like a resource, the data model that the app concerns itself with. 
The idea is that a big part of what applications do is passing data back and forth and reading/writing to databases. 
If one knows how the data looks it is possible to generate those parts of the application, since they generally function in the same way.
The entities are specified in JSON.

### Example

```
{
  "foo_type": {
    "description": "a demonstration entity",
    "fields": [
      {
        "name": "bar",
        "type": "string",
        "description": "Explanatory text about bar, these next properties are optional",
        "required": true,
        "example": "sample_value_123",
      },
      {
        "name": "baz",
        "type": "int",
      },
      {
        "name": "guid",
        "type": "uuid",
        "description": "Internal unique ID for the entity,
        "required": true,
      }
    ]
  }
}
```

You can find more examples in the `sample-data` dir.

### Types

Spectre has its own internal types that are intended to correspond to common programming constructs. They don't always map 1:1 with the datatypes in the target language, and sometimes the generation is less than perfect. Improving this is a work in progress. 

The following types are supported:

* INT
* STRING
* BOOL
* FLOAT
* ENUM  #This is only partially supported currently, in Java it will end up as a String
* TIMESTAMP
* UUID 
* UNDEFINED #Shouldn't be used, this is for when something has gone wrong

There is currently no support for nested entity types or objects. It's a nice-to-have feature that might end up being implemented later.

## Config

You can create a config file to set some metadata about your generated code, for example a namespace that will be used in package declarations.

To create a config, use the command `spectre create config` or write it in a YAML file and place in `spectre/spectre.yml`.

The config system is early in development and may be subject to change. Sorry for any breaking changes.

## Generators

Multiple different generators are available. Adding a new one is fairly quick.

### Java

This can generate various different classes relating to an entity, many of them use the Spring framework. They are available as switches in the CLI, or alternatively the `--all` switch can be used to generate everything.

#### Model

This entity is always generated and corresponds to the POJO for the entity. If generated with the `--spring-data` flag, this will be a JPA entity with database annotations.

#### DTO

A copy of the model without annotations, in a separate package for DTO:s. Enabled with the `--dto` flag.

#### Repository

A Spring Data repository interfaces for the [model](#model) class, with some standard methods specified for clarity. Enabled with the `--spring-data` flag.

#### Manager

An abstraction to encapsulate the repository and place to add business logic around CRUD operations. Enabled with the `--manager` flag.

#### REST Controller

A Spring Web controller that provides a CRUD like interface for the [model entity](#model) over REST by wrapping the [manager](#manager). Enabled with the `--spring-web` flag.

### Proto

Generates a protofile with messages and a CRUD-like service.

### Liquibase

Generates a liquibase changelog for a database schema matching the entity

### Jhipster

Generates JHipster JDL files which in turn can be used to generate Java code with their generator. This is quite similar to the code generated by the Java generator, so if not already heavily invested in JHipster framework the vanilla Java generator may be a better choice if not wanting to commit to their ecosystem.

### API.json

Generates an [api.json](https://app.apibuilder.io/doc/) specification that can be used to generate other code from the apibuilder tool. NB: We never ended up using this so support may be poor/broken.