# !/usr/bin/env python3
# Copyright (c) 2022 Institute for Quantum Computing, Baidu Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

r"""
The module of the quantum state.
"""

from .state import State, is_state_vector, is_density_matrix
from .state import _type_fetch, _type_transform
from .common import zero_state
from .common import computational_basis
from .common import bell_state
from .common import random_state
from .common import to_state
from .common import w_state
from .common import ghz_state
from .common import bell_diagonal_state
from .common import completely_mixed_computational
from .common import r_state
from .common import s_state
from .common import isotropic_state
