# mypy-boto3-forecast

[![PyPI - mypy-boto3-forecast](https://img.shields.io/pypi/v/mypy-boto3-forecast.svg?color=blue)](https://pypi.org/project/mypy-boto3-forecast)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-forecast.svg?color=blue)](https://pypi.org/project/mypy-boto3-forecast)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ForecastService 1.17.44](https://boto3.amazonaws.com/v1/documentation/api/1.17.44/reference/services/forecast.html#ForecastService) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-forecast](#mypy-boto3-forecast)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `ForecastService` service.

```bash
python -m pip install boto3-stubs[forecast]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[forecast]` in your environment: `python -m pip install 'boto3-stubs[forecast]'`

Both type checking and auto-complete should work for `ForecastService` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[forecast]` in your environment: `python -m pip install 'boto3-stubs[forecast]'`

Both type checking and auto-complete should work for `ForecastService` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[forecast]` in your environment: `python -m pip install 'boto3-stubs[forecast]'`
- Run `mypy` as usual

Type checking should work for `ForecastService` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[forecast]` in your environment: `python -m pip install 'boto3-stubs[forecast]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ForecastService` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ForecastServiceClient` provides annotations for `boto3.client("forecast")`.

```python
import boto3

from mypy_boto3_forecast import ForecastServiceClient

client: ForecastServiceClient = boto3.client("forecast")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ForecastServiceClient = session.client("forecast")
```

### Paginators annotations

`mypy_boto3_forecast.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_forecast import ForecastServiceClient
from mypy_boto3_forecast.paginator import (
    ListDatasetGroupsPaginator,
    ListDatasetImportJobsPaginator,
    ListDatasetsPaginator,
    ListForecastExportJobsPaginator,
    ListForecastsPaginator,
    ListPredictorBacktestExportJobsPaginator,
    ListPredictorsPaginator,
)

client: ForecastServiceClient = boto3.client("forecast")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_dataset_groups_paginator: ListDatasetGroupsPaginator = client.get_paginator("list_dataset_groups")
list_dataset_import_jobs_paginator: ListDatasetImportJobsPaginator = client.get_paginator("list_dataset_import_jobs")
list_datasets_paginator: ListDatasetsPaginator = client.get_paginator("list_datasets")
list_forecast_export_jobs_paginator: ListForecastExportJobsPaginator = client.get_paginator("list_forecast_export_jobs")
list_forecasts_paginator: ListForecastsPaginator = client.get_paginator("list_forecasts")
list_predictor_backtest_export_jobs_paginator: ListPredictorBacktestExportJobsPaginator = client.get_paginator("list_predictor_backtest_export_jobs")
list_predictors_paginator: ListPredictorsPaginator = client.get_paginator("list_predictors")
```







### Typed dictionations

`mypy_boto3_forecast.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_forecast.type_defs import (
    CategoricalParameterRangeTypeDef,
    ContinuousParameterRangeTypeDef,
    DataDestinationTypeDef,
    DataSourceTypeDef,
    DatasetGroupSummaryTypeDef,
    DatasetImportJobSummaryTypeDef,
    DatasetSummaryTypeDef,
    EncryptionConfigTypeDef,
    ErrorMetricTypeDef,
    EvaluationParametersTypeDef,
    EvaluationResultTypeDef,
    FeaturizationConfigTypeDef,
    FeaturizationMethodTypeDef,
    FeaturizationTypeDef,
    ForecastExportJobSummaryTypeDef,
    ForecastSummaryTypeDef,
    HyperParameterTuningJobConfigTypeDef,
    InputDataConfigTypeDef,
    IntegerParameterRangeTypeDef,
    MetricsTypeDef,
    ParameterRangesTypeDef,
    PredictorBacktestExportJobSummaryTypeDef,
    PredictorExecutionDetailsTypeDef,
    PredictorExecutionTypeDef,
    PredictorSummaryTypeDef,
    S3ConfigTypeDef,
    SchemaAttributeTypeDef,
    SchemaTypeDef,
    StatisticsTypeDef,
    SupplementaryFeatureTypeDef,
    TagTypeDef,
    TestWindowSummaryTypeDef,
    WeightedQuantileLossTypeDef,
    WindowSummaryTypeDef,
    CreateDatasetGroupResponseTypeDef,
    CreateDatasetImportJobResponseTypeDef,
    CreateDatasetResponseTypeDef,
    CreateForecastExportJobResponseTypeDef,
    CreateForecastResponseTypeDef,
    CreatePredictorBacktestExportJobResponseTypeDef,
    CreatePredictorResponseTypeDef,
    DescribeDatasetGroupResponseTypeDef,
    DescribeDatasetImportJobResponseTypeDef,
    DescribeDatasetResponseTypeDef,
    DescribeForecastExportJobResponseTypeDef,
    DescribeForecastResponseTypeDef,
    DescribePredictorBacktestExportJobResponseTypeDef,
    DescribePredictorResponseTypeDef,
    FilterTypeDef,
    GetAccuracyMetricsResponseTypeDef,
    ListDatasetGroupsResponseTypeDef,
    ListDatasetImportJobsResponseTypeDef,
    ListDatasetsResponseTypeDef,
    ListForecastExportJobsResponseTypeDef,
    ListForecastsResponseTypeDef,
    ListPredictorBacktestExportJobsResponseTypeDef,
    ListPredictorsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
)

def get_structure() -> CategoricalParameterRangeTypeDef:
    return {
      ...
    }
```
