# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: wechaty/puppet.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import AsyncIterable, AsyncIterator, Dict, Iterable, List, Optional, Union

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class PuppetStub(betterproto.ServiceStub):
    async def start(self) -> "puppet.StartResponse":

        request = puppet.StartRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/Start", request, puppet.StartResponse
        )

    async def stop(self) -> "puppet.StopResponse":

        request = puppet.StopRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/Stop", request, puppet.StopResponse
        )

    async def logout(self) -> "puppet.LogoutResponse":

        request = puppet.LogoutRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/Logout", request, puppet.LogoutResponse
        )

    async def ding(self, *, data: str = "") -> "puppet.DingResponse":

        request = puppet.DingRequest()
        request.data = data

        return await self._unary_unary(
            "/wechaty.Puppet/Ding", request, puppet.DingResponse
        )

    async def version(self) -> "puppet.VersionResponse":

        request = puppet.VersionRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/Version", request, puppet.VersionResponse
        )

    async def event(self) -> AsyncIterator["puppet.EventResponse"]:

        request = puppet.EventRequest()

        async for response in self._unary_stream(
            "/wechaty.Puppet/Event",
            request,
            puppet.EventResponse,
        ):
            yield response

    async def dirty_payload(
        self, *, type: "PayloadType" = None, id: str = ""
    ) -> "puppet.DirtyPayloadResponse":

        request = puppet.DirtyPayloadRequest()
        request.type = type
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/DirtyPayload", request, puppet.DirtyPayloadResponse
        )

    async def contact_self_qr_code(self) -> "puppet.ContactSelfQrCodeResponse":

        request = puppet.ContactSelfQrCodeRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/ContactSelfQRCode",
            request,
            puppet.ContactSelfQrCodeResponse,
        )

    async def contact_self_name(
        self, *, name: str = ""
    ) -> "puppet.ContactSelfNameResponse":

        request = puppet.ContactSelfNameRequest()
        request.name = name

        return await self._unary_unary(
            "/wechaty.Puppet/ContactSelfName", request, puppet.ContactSelfNameResponse
        )

    async def contact_self_signature(
        self, *, signature: str = ""
    ) -> "puppet.ContactSelfSignatureResponse":

        request = puppet.ContactSelfSignatureRequest()
        request.signature = signature

        return await self._unary_unary(
            "/wechaty.Puppet/ContactSelfSignature",
            request,
            puppet.ContactSelfSignatureResponse,
        )

    async def contact_payload(self, *, id: str = "") -> "puppet.ContactPayloadResponse":

        request = puppet.ContactPayloadRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/ContactPayload", request, puppet.ContactPayloadResponse
        )

    async def contact_alias(
        self, *, id: str = "", alias: Optional[str] = None
    ) -> "puppet.ContactAliasResponse":

        request = puppet.ContactAliasRequest()
        request.id = id
        if alias is not None:
            request.alias = alias

        return await self._unary_unary(
            "/wechaty.Puppet/ContactAlias", request, puppet.ContactAliasResponse
        )

    async def contact_avatar(
        self, *, id: str = "", filebox: Optional[str] = None
    ) -> "puppet.ContactAvatarResponse":

        request = puppet.ContactAvatarRequest()
        request.id = id
        if filebox is not None:
            request.filebox = filebox

        return await self._unary_unary(
            "/wechaty.Puppet/ContactAvatar", request, puppet.ContactAvatarResponse
        )

    async def contact_phone(
        self, *, contact_id: str = "", phone_list: Optional[List[str]] = None
    ) -> "puppet.ContactPhoneResponse":
        phone_list = phone_list or []

        request = puppet.ContactPhoneRequest()
        request.contact_id = contact_id
        request.phone_list = phone_list

        return await self._unary_unary(
            "/wechaty.Puppet/ContactPhone", request, puppet.ContactPhoneResponse
        )

    async def contact_corporation_remark(
        self, *, contact_id: str = "", corporation_remark: Optional[str] = None
    ) -> "puppet.ContactCorporationRemarkResponse":

        request = puppet.ContactCorporationRemarkRequest()
        request.contact_id = contact_id
        if corporation_remark is not None:
            request.corporation_remark = corporation_remark

        return await self._unary_unary(
            "/wechaty.Puppet/ContactCorporationRemark",
            request,
            puppet.ContactCorporationRemarkResponse,
        )

    async def contact_description(
        self, *, contact_id: str = "", description: Optional[str] = None
    ) -> "puppet.ContactDescriptionResponse":

        request = puppet.ContactDescriptionRequest()
        request.contact_id = contact_id
        if description is not None:
            request.description = description

        return await self._unary_unary(
            "/wechaty.Puppet/ContactDescription",
            request,
            puppet.ContactDescriptionResponse,
        )

    async def contact_list(self) -> "puppet.ContactListResponse":

        request = puppet.ContactListRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/ContactList", request, puppet.ContactListResponse
        )

    async def friendship_payload(
        self, *, id: str = "", payload: Optional[str] = None
    ) -> "puppet.FriendshipPayloadResponse":

        request = puppet.FriendshipPayloadRequest()
        request.id = id
        if payload is not None:
            request.payload = payload

        return await self._unary_unary(
            "/wechaty.Puppet/FriendshipPayload",
            request,
            puppet.FriendshipPayloadResponse,
        )

    async def friendship_search_phone(
        self, *, phone: str = ""
    ) -> "puppet.FriendshipSearchPhoneResponse":

        request = puppet.FriendshipSearchPhoneRequest()
        request.phone = phone

        return await self._unary_unary(
            "/wechaty.Puppet/FriendshipSearchPhone",
            request,
            puppet.FriendshipSearchPhoneResponse,
        )

    async def friendship_search_weixin(
        self, *, weixin: str = ""
    ) -> "puppet.FriendshipSearchWeixinResponse":

        request = puppet.FriendshipSearchWeixinRequest()
        request.weixin = weixin

        return await self._unary_unary(
            "/wechaty.Puppet/FriendshipSearchWeixin",
            request,
            puppet.FriendshipSearchWeixinResponse,
        )

    async def friendship_add(
        self,
        *,
        contact_id: str = "",
        hello: str = "",
        source_room_id: Optional[str] = None,
        source_contact_id: Optional[str] = None,
    ) -> "puppet.FriendshipAddResponse":

        request = puppet.FriendshipAddRequest()
        request.contact_id = contact_id
        request.hello = hello
        if source_room_id is not None:
            request.source_room_id = source_room_id
        if source_contact_id is not None:
            request.source_contact_id = source_contact_id

        return await self._unary_unary(
            "/wechaty.Puppet/FriendshipAdd", request, puppet.FriendshipAddResponse
        )

    async def friendship_accept(
        self, *, id: str = ""
    ) -> "puppet.FriendshipAcceptResponse":

        request = puppet.FriendshipAcceptRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/FriendshipAccept", request, puppet.FriendshipAcceptResponse
        )

    async def message_file(self, *, id: str = "") -> "puppet.MessageFileResponse":

        request = puppet.MessageFileRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageFile", request, puppet.MessageFileResponse
        )

    async def message_image(
        self, *, id: str = "", type: "ImageType" = None
    ) -> "puppet.MessageImageResponse":

        request = puppet.MessageImageRequest()
        request.id = id
        request.type = type

        return await self._unary_unary(
            "/wechaty.Puppet/MessageImage", request, puppet.MessageImageResponse
        )

    async def message_send_file(
        self, *, conversation_id: str = "", filebox: str = ""
    ) -> "puppet.MessageSendFileResponse":

        request = puppet.MessageSendFileRequest()
        request.conversation_id = conversation_id
        request.filebox = filebox

        return await self._unary_unary(
            "/wechaty.Puppet/MessageSendFile", request, puppet.MessageSendFileResponse
        )

    async def message_payload(self, *, id: str = "") -> "puppet.MessagePayloadResponse":

        request = puppet.MessagePayloadRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/MessagePayload", request, puppet.MessagePayloadResponse
        )

    async def message_contact(self, *, id: str = "") -> "puppet.MessageContactResponse":

        request = puppet.MessageContactRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageContact", request, puppet.MessageContactResponse
        )

    async def message_file_stream(
        self, *, id: str = ""
    ) -> AsyncIterator["puppet.MessageFileStreamResponse"]:

        request = puppet.MessageFileStreamRequest()
        request.id = id

        async for response in self._unary_stream(
            "/wechaty.Puppet/MessageFileStream",
            request,
            puppet.MessageFileStreamResponse,
        ):
            yield response

    async def message_image_stream(
        self, *, id: str = "", type: "ImageType" = None
    ) -> AsyncIterator["puppet.MessageImageStreamResponse"]:

        request = puppet.MessageImageStreamRequest()
        request.id = id
        request.type = type

        async for response in self._unary_stream(
            "/wechaty.Puppet/MessageImageStream",
            request,
            puppet.MessageImageStreamResponse,
        ):
            yield response

    async def message_mini_program(
        self, *, id: str = ""
    ) -> "puppet.MessageMiniProgramResponse":

        request = puppet.MessageMiniProgramRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageMiniProgram",
            request,
            puppet.MessageMiniProgramResponse,
        )

    async def message_url(self, *, id: str = "") -> "puppet.MessageUrlResponse":

        request = puppet.MessageUrlRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageUrl", request, puppet.MessageUrlResponse
        )

    async def message_recall(self, *, id: str = "") -> "puppet.MessageRecallResponse":

        request = puppet.MessageRecallRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageRecall", request, puppet.MessageRecallResponse
        )

    async def message_forward(
        self, *, message_id: str = "", conversation_id: str = ""
    ) -> "puppet.MessageForwardResponse":

        request = puppet.MessageForwardRequest()
        request.message_id = message_id
        request.conversation_id = conversation_id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageForward", request, puppet.MessageForwardResponse
        )

    async def message_location(
        self, *, id: str = ""
    ) -> "puppet.MessageLocationResponse":

        request = puppet.MessageLocationRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageLocation", request, puppet.MessageLocationResponse
        )

    async def message_send_contact(
        self, *, conversation_id: str = "", contact_id: str = ""
    ) -> "puppet.MessageSendContactResponse":

        request = puppet.MessageSendContactRequest()
        request.conversation_id = conversation_id
        request.contact_id = contact_id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageSendContact",
            request,
            puppet.MessageSendContactResponse,
        )

    async def message_send_file_stream(
        self,
        request_iterator: Union[
            AsyncIterable["puppet.MessageSendFileStreamRequest"],
            Iterable["puppet.MessageSendFileStreamRequest"],
        ],
    ) -> "puppet.MessageSendFileStreamResponse":

        return await self._stream_unary(
            "/wechaty.Puppet/MessageSendFileStream",
            request_iterator,
            puppet.MessageSendFileStreamRequest,
            puppet.MessageSendFileStreamResponse,
        )

    async def message_send_text(
        self,
        *,
        conversation_id: str = "",
        text: str = "",
        mentional_ids: Optional[List[str]] = None,
    ) -> "puppet.MessageSendTextResponse":
        mentional_ids = mentional_ids or []

        request = puppet.MessageSendTextRequest()
        request.conversation_id = conversation_id
        request.text = text
        request.mentional_ids = mentional_ids

        return await self._unary_unary(
            "/wechaty.Puppet/MessageSendText", request, puppet.MessageSendTextResponse
        )

    async def message_send_mini_program(
        self,
        *,
        conversation_id: str = "",
        mini_program_deprecated: str = "",
        mini_program: "MiniProgramPayload" = None,
    ) -> "puppet.MessageSendMiniProgramResponse":

        request = puppet.MessageSendMiniProgramRequest()
        request.conversation_id = conversation_id
        request.mini_program_deprecated = mini_program_deprecated
        if mini_program is not None:
            request.mini_program = mini_program

        return await self._unary_unary(
            "/wechaty.Puppet/MessageSendMiniProgram",
            request,
            puppet.MessageSendMiniProgramResponse,
        )

    async def message_send_url(
        self,
        *,
        conversation_id: str = "",
        url_link_deprecated: str = "",
        url_link: "UrlLinkPayload" = None,
    ) -> "puppet.MessageSendUrlResponse":

        request = puppet.MessageSendUrlRequest()
        request.conversation_id = conversation_id
        request.url_link_deprecated = url_link_deprecated
        if url_link is not None:
            request.url_link = url_link

        return await self._unary_unary(
            "/wechaty.Puppet/MessageSendUrl", request, puppet.MessageSendUrlResponse
        )

    async def message_send_location(
        self, *, conversation_id: str = "", location: "LocationPayload" = None
    ) -> "puppet.MessageSendLocationResponse":

        request = puppet.MessageSendLocationRequest()
        request.conversation_id = conversation_id
        if location is not None:
            request.location = location

        return await self._unary_unary(
            "/wechaty.Puppet/MessageSendLocation",
            request,
            puppet.MessageSendLocationResponse,
        )

    async def room_payload(self, *, id: str = "") -> "puppet.RoomPayloadResponse":

        request = puppet.RoomPayloadRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomPayload", request, puppet.RoomPayloadResponse
        )

    async def room_list(self) -> "puppet.RoomListResponse":

        request = puppet.RoomListRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/RoomList", request, puppet.RoomListResponse
        )

    async def room_add(
        self, *, id: str = "", contact_id: str = "", invite_only: bool = False
    ) -> "puppet.RoomAddResponse":

        request = puppet.RoomAddRequest()
        request.id = id
        request.contact_id = contact_id
        request.invite_only = invite_only

        return await self._unary_unary(
            "/wechaty.Puppet/RoomAdd", request, puppet.RoomAddResponse
        )

    async def room_avatar(self, *, id: str = "") -> "puppet.RoomAvatarResponse":

        request = puppet.RoomAvatarRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomAvatar", request, puppet.RoomAvatarResponse
        )

    async def room_create(
        self, *, contact_ids: Optional[List[str]] = None, topic: str = ""
    ) -> "puppet.RoomCreateResponse":
        contact_ids = contact_ids or []

        request = puppet.RoomCreateRequest()
        request.contact_ids = contact_ids
        request.topic = topic

        return await self._unary_unary(
            "/wechaty.Puppet/RoomCreate", request, puppet.RoomCreateResponse
        )

    async def room_del(
        self, *, id: str = "", contact_id: str = ""
    ) -> "puppet.RoomDelResponse":

        request = puppet.RoomDelRequest()
        request.id = id
        request.contact_id = contact_id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomDel", request, puppet.RoomDelResponse
        )

    async def room_quit(self, *, id: str = "") -> "puppet.RoomQuitResponse":

        request = puppet.RoomQuitRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomQuit", request, puppet.RoomQuitResponse
        )

    async def room_topic(
        self, *, id: str = "", topic: Optional[str] = None
    ) -> "puppet.RoomTopicResponse":

        request = puppet.RoomTopicRequest()
        request.id = id
        if topic is not None:
            request.topic = topic

        return await self._unary_unary(
            "/wechaty.Puppet/RoomTopic", request, puppet.RoomTopicResponse
        )

    async def room_qr_code(self) -> "puppet.RoomQrCodeResponse":

        request = puppet.RoomQrCodeRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/RoomQRCode", request, puppet.RoomQrCodeResponse
        )

    async def room_announce(
        self, *, id: str = "", text: Optional[str] = None
    ) -> "puppet.RoomAnnounceResponse":

        request = puppet.RoomAnnounceRequest()
        request.id = id
        if text is not None:
            request.text = text

        return await self._unary_unary(
            "/wechaty.Puppet/RoomAnnounce", request, puppet.RoomAnnounceResponse
        )

    async def room_member_payload(
        self, *, id: str = "", member_id: str = ""
    ) -> "puppet.RoomMemberPayloadResponse":

        request = puppet.RoomMemberPayloadRequest()
        request.id = id
        request.member_id = member_id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomMemberPayload",
            request,
            puppet.RoomMemberPayloadResponse,
        )

    async def room_member_list(
        self, *, id: str = ""
    ) -> "puppet.RoomMemberListResponse":

        request = puppet.RoomMemberListRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomMemberList", request, puppet.RoomMemberListResponse
        )

    async def room_invitation_payload(
        self, *, id: str = "", payload: Optional[str] = None
    ) -> "puppet.RoomInvitationPayloadResponse":

        request = puppet.RoomInvitationPayloadRequest()
        request.id = id
        if payload is not None:
            request.payload = payload

        return await self._unary_unary(
            "/wechaty.Puppet/RoomInvitationPayload",
            request,
            puppet.RoomInvitationPayloadResponse,
        )

    async def room_invitation_accept(
        self, *, id: str = ""
    ) -> "puppet.RoomInvitationAcceptResponse":

        request = puppet.RoomInvitationAcceptRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomInvitationAccept",
            request,
            puppet.RoomInvitationAcceptResponse,
        )

    async def tag_contact_add(
        self, *, id: str = "", contact_id: str = ""
    ) -> "puppet.TagContactAddResponse":

        request = puppet.TagContactAddRequest()
        request.id = id
        request.contact_id = contact_id

        return await self._unary_unary(
            "/wechaty.Puppet/TagContactAdd", request, puppet.TagContactAddResponse
        )

    async def tag_contact_remove(
        self, *, id: str = "", contact_id: str = ""
    ) -> "puppet.TagContactRemoveResponse":

        request = puppet.TagContactRemoveRequest()
        request.id = id
        request.contact_id = contact_id

        return await self._unary_unary(
            "/wechaty.Puppet/TagContactRemove", request, puppet.TagContactRemoveResponse
        )

    async def tag_contact_delete(
        self, *, id: str = ""
    ) -> "puppet.TagContactDeleteResponse":

        request = puppet.TagContactDeleteRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/TagContactDelete", request, puppet.TagContactDeleteResponse
        )

    async def tag_contact_list(
        self, *, contact_id: Optional[str] = None
    ) -> "puppet.TagContactListResponse":

        request = puppet.TagContactListRequest()
        if contact_id is not None:
            request.contact_id = contact_id

        return await self._unary_unary(
            "/wechaty.Puppet/TagContactList", request, puppet.TagContactListResponse
        )


class PuppetBase(ServiceBase):
    async def start(self) -> "puppet.StartResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def stop(self) -> "puppet.StopResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def logout(self) -> "puppet.LogoutResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def ding(self, data: str) -> "puppet.DingResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def version(self) -> "puppet.VersionResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def event(self) -> AsyncIterator["puppet.EventResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def dirty_payload(
        self, type: "PayloadType", id: str
    ) -> "puppet.DirtyPayloadResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contact_self_qr_code(self) -> "puppet.ContactSelfQrCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contact_self_name(self, name: str) -> "puppet.ContactSelfNameResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contact_self_signature(
        self, signature: str
    ) -> "puppet.ContactSelfSignatureResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contact_payload(self, id: str) -> "puppet.ContactPayloadResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contact_alias(
        self, id: str, alias: Optional[str]
    ) -> "puppet.ContactAliasResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contact_avatar(
        self, id: str, filebox: Optional[str]
    ) -> "puppet.ContactAvatarResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contact_phone(
        self, contact_id: str, phone_list: Optional[List[str]]
    ) -> "puppet.ContactPhoneResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contact_corporation_remark(
        self, contact_id: str, corporation_remark: Optional[str]
    ) -> "puppet.ContactCorporationRemarkResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contact_description(
        self, contact_id: str, description: Optional[str]
    ) -> "puppet.ContactDescriptionResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contact_list(self) -> "puppet.ContactListResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def friendship_payload(
        self, id: str, payload: Optional[str]
    ) -> "puppet.FriendshipPayloadResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def friendship_search_phone(
        self, phone: str
    ) -> "puppet.FriendshipSearchPhoneResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def friendship_search_weixin(
        self, weixin: str
    ) -> "puppet.FriendshipSearchWeixinResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def friendship_add(
        self,
        contact_id: str,
        hello: str,
        source_room_id: Optional[str],
        source_contact_id: Optional[str],
    ) -> "puppet.FriendshipAddResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def friendship_accept(self, id: str) -> "puppet.FriendshipAcceptResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_file(self, id: str) -> "puppet.MessageFileResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_image(
        self, id: str, type: "ImageType"
    ) -> "puppet.MessageImageResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_send_file(
        self, conversation_id: str, filebox: str
    ) -> "puppet.MessageSendFileResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_payload(self, id: str) -> "puppet.MessagePayloadResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_contact(self, id: str) -> "puppet.MessageContactResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_file_stream(
        self, id: str
    ) -> AsyncIterator["puppet.MessageFileStreamResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_image_stream(
        self, id: str, type: "ImageType"
    ) -> AsyncIterator["puppet.MessageImageStreamResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_mini_program(
        self, id: str
    ) -> "puppet.MessageMiniProgramResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_url(self, id: str) -> "puppet.MessageUrlResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_recall(self, id: str) -> "puppet.MessageRecallResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_forward(
        self, message_id: str, conversation_id: str
    ) -> "puppet.MessageForwardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_location(self, id: str) -> "puppet.MessageLocationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_send_contact(
        self, conversation_id: str, contact_id: str
    ) -> "puppet.MessageSendContactResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_send_file_stream(
        self, request_iterator: AsyncIterator["puppet.MessageSendFileStreamRequest"]
    ) -> "puppet.MessageSendFileStreamResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_send_text(
        self, conversation_id: str, text: str, mentional_ids: Optional[List[str]]
    ) -> "puppet.MessageSendTextResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_send_mini_program(
        self,
        conversation_id: str,
        mini_program_deprecated: str,
        mini_program: "MiniProgramPayload",
    ) -> "puppet.MessageSendMiniProgramResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_send_url(
        self, conversation_id: str, url_link_deprecated: str, url_link: "UrlLinkPayload"
    ) -> "puppet.MessageSendUrlResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def message_send_location(
        self, conversation_id: str, location: "LocationPayload"
    ) -> "puppet.MessageSendLocationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_payload(self, id: str) -> "puppet.RoomPayloadResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_list(self) -> "puppet.RoomListResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_add(
        self, id: str, contact_id: str, invite_only: bool
    ) -> "puppet.RoomAddResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_avatar(self, id: str) -> "puppet.RoomAvatarResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_create(
        self, contact_ids: Optional[List[str]], topic: str
    ) -> "puppet.RoomCreateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_del(self, id: str, contact_id: str) -> "puppet.RoomDelResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_quit(self, id: str) -> "puppet.RoomQuitResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_topic(
        self, id: str, topic: Optional[str]
    ) -> "puppet.RoomTopicResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_qr_code(self) -> "puppet.RoomQrCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_announce(
        self, id: str, text: Optional[str]
    ) -> "puppet.RoomAnnounceResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_member_payload(
        self, id: str, member_id: str
    ) -> "puppet.RoomMemberPayloadResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_member_list(self, id: str) -> "puppet.RoomMemberListResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_invitation_payload(
        self, id: str, payload: Optional[str]
    ) -> "puppet.RoomInvitationPayloadResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def room_invitation_accept(
        self, id: str
    ) -> "puppet.RoomInvitationAcceptResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def tag_contact_add(
        self, id: str, contact_id: str
    ) -> "puppet.TagContactAddResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def tag_contact_remove(
        self, id: str, contact_id: str
    ) -> "puppet.TagContactRemoveResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def tag_contact_delete(self, id: str) -> "puppet.TagContactDeleteResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def tag_contact_list(
        self, contact_id: Optional[str]
    ) -> "puppet.TagContactListResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_start(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.start(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_stop(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.stop(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_logout(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.logout(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_ding(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "data": request.data,
        }

        response = await self.ding(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_version(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.version(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_event(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        await self._call_rpc_handler_server_stream(
            self.event,
            stream,
            request_kwargs,
        )

    async def __rpc_dirty_payload(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "type": request.type,
            "id": request.id,
        }

        response = await self.dirty_payload(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contact_self_qr_code(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.contact_self_qr_code(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contact_self_name(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "name": request.name,
        }

        response = await self.contact_self_name(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contact_self_signature(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "signature": request.signature,
        }

        response = await self.contact_self_signature(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contact_payload(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.contact_payload(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contact_alias(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "alias": request.alias,
        }

        response = await self.contact_alias(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contact_avatar(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "filebox": request.filebox,
        }

        response = await self.contact_avatar(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contact_phone(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "contact_id": request.contact_id,
            "phone_list": request.phone_list,
        }

        response = await self.contact_phone(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contact_corporation_remark(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "contact_id": request.contact_id,
            "corporation_remark": request.corporation_remark,
        }

        response = await self.contact_corporation_remark(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contact_description(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "contact_id": request.contact_id,
            "description": request.description,
        }

        response = await self.contact_description(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contact_list(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.contact_list(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_friendship_payload(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "payload": request.payload,
        }

        response = await self.friendship_payload(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_friendship_search_phone(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "phone": request.phone,
        }

        response = await self.friendship_search_phone(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_friendship_search_weixin(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "weixin": request.weixin,
        }

        response = await self.friendship_search_weixin(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_friendship_add(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "contact_id": request.contact_id,
            "hello": request.hello,
            "source_room_id": request.source_room_id,
            "source_contact_id": request.source_contact_id,
        }

        response = await self.friendship_add(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_friendship_accept(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.friendship_accept(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_file(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.message_file(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_image(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "type": request.type,
        }

        response = await self.message_image(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_send_file(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "conversation_id": request.conversation_id,
            "filebox": request.filebox,
        }

        response = await self.message_send_file(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_payload(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.message_payload(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_contact(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.message_contact(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_file_stream(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        await self._call_rpc_handler_server_stream(
            self.message_file_stream,
            stream,
            request_kwargs,
        )

    async def __rpc_message_image_stream(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "type": request.type,
        }

        await self._call_rpc_handler_server_stream(
            self.message_image_stream,
            stream,
            request_kwargs,
        )

    async def __rpc_message_mini_program(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.message_mini_program(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_url(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.message_url(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_recall(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.message_recall(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_forward(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "message_id": request.message_id,
            "conversation_id": request.conversation_id,
        }

        response = await self.message_forward(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_location(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.message_location(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_send_contact(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "conversation_id": request.conversation_id,
            "contact_id": request.contact_id,
        }

        response = await self.message_send_contact(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_send_file_stream(
        self, stream: grpclib.server.Stream
    ) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        response = await self.message_send_file_stream(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_send_text(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "conversation_id": request.conversation_id,
            "text": request.text,
            "mentional_ids": request.mentional_ids,
        }

        response = await self.message_send_text(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_send_mini_program(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "conversation_id": request.conversation_id,
            "mini_program_deprecated": request.mini_program_deprecated,
            "mini_program": request.mini_program,
        }

        response = await self.message_send_mini_program(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_send_url(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "conversation_id": request.conversation_id,
            "url_link_deprecated": request.url_link_deprecated,
            "url_link": request.url_link,
        }

        response = await self.message_send_url(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_message_send_location(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "conversation_id": request.conversation_id,
            "location": request.location,
        }

        response = await self.message_send_location(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_payload(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.room_payload(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_list(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.room_list(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_add(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "contact_id": request.contact_id,
            "invite_only": request.invite_only,
        }

        response = await self.room_add(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_avatar(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.room_avatar(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_create(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "contact_ids": request.contact_ids,
            "topic": request.topic,
        }

        response = await self.room_create(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_del(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "contact_id": request.contact_id,
        }

        response = await self.room_del(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_quit(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.room_quit(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_topic(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "topic": request.topic,
        }

        response = await self.room_topic(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_qr_code(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.room_qr_code(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_announce(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "text": request.text,
        }

        response = await self.room_announce(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_member_payload(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "member_id": request.member_id,
        }

        response = await self.room_member_payload(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_member_list(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.room_member_list(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_invitation_payload(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "payload": request.payload,
        }

        response = await self.room_invitation_payload(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_room_invitation_accept(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.room_invitation_accept(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_tag_contact_add(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "contact_id": request.contact_id,
        }

        response = await self.tag_contact_add(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_tag_contact_remove(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
            "contact_id": request.contact_id,
        }

        response = await self.tag_contact_remove(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_tag_contact_delete(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.tag_contact_delete(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_tag_contact_list(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "contact_id": request.contact_id,
        }

        response = await self.tag_contact_list(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/wechaty.Puppet/Start": grpclib.const.Handler(
                self.__rpc_start,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.StartRequest,
                puppet.StartResponse,
            ),
            "/wechaty.Puppet/Stop": grpclib.const.Handler(
                self.__rpc_stop,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.StopRequest,
                puppet.StopResponse,
            ),
            "/wechaty.Puppet/Logout": grpclib.const.Handler(
                self.__rpc_logout,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.LogoutRequest,
                puppet.LogoutResponse,
            ),
            "/wechaty.Puppet/Ding": grpclib.const.Handler(
                self.__rpc_ding,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.DingRequest,
                puppet.DingResponse,
            ),
            "/wechaty.Puppet/Version": grpclib.const.Handler(
                self.__rpc_version,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.VersionRequest,
                puppet.VersionResponse,
            ),
            "/wechaty.Puppet/Event": grpclib.const.Handler(
                self.__rpc_event,
                grpclib.const.Cardinality.UNARY_STREAM,
                puppet.EventRequest,
                puppet.EventResponse,
            ),
            "/wechaty.Puppet/DirtyPayload": grpclib.const.Handler(
                self.__rpc_dirty_payload,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.DirtyPayloadRequest,
                puppet.DirtyPayloadResponse,
            ),
            "/wechaty.Puppet/ContactSelfQRCode": grpclib.const.Handler(
                self.__rpc_contact_self_qr_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.ContactSelfQrCodeRequest,
                puppet.ContactSelfQrCodeResponse,
            ),
            "/wechaty.Puppet/ContactSelfName": grpclib.const.Handler(
                self.__rpc_contact_self_name,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.ContactSelfNameRequest,
                puppet.ContactSelfNameResponse,
            ),
            "/wechaty.Puppet/ContactSelfSignature": grpclib.const.Handler(
                self.__rpc_contact_self_signature,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.ContactSelfSignatureRequest,
                puppet.ContactSelfSignatureResponse,
            ),
            "/wechaty.Puppet/ContactPayload": grpclib.const.Handler(
                self.__rpc_contact_payload,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.ContactPayloadRequest,
                puppet.ContactPayloadResponse,
            ),
            "/wechaty.Puppet/ContactAlias": grpclib.const.Handler(
                self.__rpc_contact_alias,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.ContactAliasRequest,
                puppet.ContactAliasResponse,
            ),
            "/wechaty.Puppet/ContactAvatar": grpclib.const.Handler(
                self.__rpc_contact_avatar,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.ContactAvatarRequest,
                puppet.ContactAvatarResponse,
            ),
            "/wechaty.Puppet/ContactPhone": grpclib.const.Handler(
                self.__rpc_contact_phone,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.ContactPhoneRequest,
                puppet.ContactPhoneResponse,
            ),
            "/wechaty.Puppet/ContactCorporationRemark": grpclib.const.Handler(
                self.__rpc_contact_corporation_remark,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.ContactCorporationRemarkRequest,
                puppet.ContactCorporationRemarkResponse,
            ),
            "/wechaty.Puppet/ContactDescription": grpclib.const.Handler(
                self.__rpc_contact_description,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.ContactDescriptionRequest,
                puppet.ContactDescriptionResponse,
            ),
            "/wechaty.Puppet/ContactList": grpclib.const.Handler(
                self.__rpc_contact_list,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.ContactListRequest,
                puppet.ContactListResponse,
            ),
            "/wechaty.Puppet/FriendshipPayload": grpclib.const.Handler(
                self.__rpc_friendship_payload,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.FriendshipPayloadRequest,
                puppet.FriendshipPayloadResponse,
            ),
            "/wechaty.Puppet/FriendshipSearchPhone": grpclib.const.Handler(
                self.__rpc_friendship_search_phone,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.FriendshipSearchPhoneRequest,
                puppet.FriendshipSearchPhoneResponse,
            ),
            "/wechaty.Puppet/FriendshipSearchWeixin": grpclib.const.Handler(
                self.__rpc_friendship_search_weixin,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.FriendshipSearchWeixinRequest,
                puppet.FriendshipSearchWeixinResponse,
            ),
            "/wechaty.Puppet/FriendshipAdd": grpclib.const.Handler(
                self.__rpc_friendship_add,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.FriendshipAddRequest,
                puppet.FriendshipAddResponse,
            ),
            "/wechaty.Puppet/FriendshipAccept": grpclib.const.Handler(
                self.__rpc_friendship_accept,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.FriendshipAcceptRequest,
                puppet.FriendshipAcceptResponse,
            ),
            "/wechaty.Puppet/MessageFile": grpclib.const.Handler(
                self.__rpc_message_file,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageFileRequest,
                puppet.MessageFileResponse,
            ),
            "/wechaty.Puppet/MessageImage": grpclib.const.Handler(
                self.__rpc_message_image,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageImageRequest,
                puppet.MessageImageResponse,
            ),
            "/wechaty.Puppet/MessageSendFile": grpclib.const.Handler(
                self.__rpc_message_send_file,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageSendFileRequest,
                puppet.MessageSendFileResponse,
            ),
            "/wechaty.Puppet/MessagePayload": grpclib.const.Handler(
                self.__rpc_message_payload,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessagePayloadRequest,
                puppet.MessagePayloadResponse,
            ),
            "/wechaty.Puppet/MessageContact": grpclib.const.Handler(
                self.__rpc_message_contact,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageContactRequest,
                puppet.MessageContactResponse,
            ),
            "/wechaty.Puppet/MessageFileStream": grpclib.const.Handler(
                self.__rpc_message_file_stream,
                grpclib.const.Cardinality.UNARY_STREAM,
                puppet.MessageFileStreamRequest,
                puppet.MessageFileStreamResponse,
            ),
            "/wechaty.Puppet/MessageImageStream": grpclib.const.Handler(
                self.__rpc_message_image_stream,
                grpclib.const.Cardinality.UNARY_STREAM,
                puppet.MessageImageStreamRequest,
                puppet.MessageImageStreamResponse,
            ),
            "/wechaty.Puppet/MessageMiniProgram": grpclib.const.Handler(
                self.__rpc_message_mini_program,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageMiniProgramRequest,
                puppet.MessageMiniProgramResponse,
            ),
            "/wechaty.Puppet/MessageUrl": grpclib.const.Handler(
                self.__rpc_message_url,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageUrlRequest,
                puppet.MessageUrlResponse,
            ),
            "/wechaty.Puppet/MessageRecall": grpclib.const.Handler(
                self.__rpc_message_recall,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageRecallRequest,
                puppet.MessageRecallResponse,
            ),
            "/wechaty.Puppet/MessageForward": grpclib.const.Handler(
                self.__rpc_message_forward,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageForwardRequest,
                puppet.MessageForwardResponse,
            ),
            "/wechaty.Puppet/MessageLocation": grpclib.const.Handler(
                self.__rpc_message_location,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageLocationRequest,
                puppet.MessageLocationResponse,
            ),
            "/wechaty.Puppet/MessageSendContact": grpclib.const.Handler(
                self.__rpc_message_send_contact,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageSendContactRequest,
                puppet.MessageSendContactResponse,
            ),
            "/wechaty.Puppet/MessageSendFileStream": grpclib.const.Handler(
                self.__rpc_message_send_file_stream,
                grpclib.const.Cardinality.STREAM_UNARY,
                puppet.MessageSendFileStreamRequest,
                puppet.MessageSendFileStreamResponse,
            ),
            "/wechaty.Puppet/MessageSendText": grpclib.const.Handler(
                self.__rpc_message_send_text,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageSendTextRequest,
                puppet.MessageSendTextResponse,
            ),
            "/wechaty.Puppet/MessageSendMiniProgram": grpclib.const.Handler(
                self.__rpc_message_send_mini_program,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageSendMiniProgramRequest,
                puppet.MessageSendMiniProgramResponse,
            ),
            "/wechaty.Puppet/MessageSendUrl": grpclib.const.Handler(
                self.__rpc_message_send_url,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageSendUrlRequest,
                puppet.MessageSendUrlResponse,
            ),
            "/wechaty.Puppet/MessageSendLocation": grpclib.const.Handler(
                self.__rpc_message_send_location,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.MessageSendLocationRequest,
                puppet.MessageSendLocationResponse,
            ),
            "/wechaty.Puppet/RoomPayload": grpclib.const.Handler(
                self.__rpc_room_payload,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomPayloadRequest,
                puppet.RoomPayloadResponse,
            ),
            "/wechaty.Puppet/RoomList": grpclib.const.Handler(
                self.__rpc_room_list,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomListRequest,
                puppet.RoomListResponse,
            ),
            "/wechaty.Puppet/RoomAdd": grpclib.const.Handler(
                self.__rpc_room_add,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomAddRequest,
                puppet.RoomAddResponse,
            ),
            "/wechaty.Puppet/RoomAvatar": grpclib.const.Handler(
                self.__rpc_room_avatar,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomAvatarRequest,
                puppet.RoomAvatarResponse,
            ),
            "/wechaty.Puppet/RoomCreate": grpclib.const.Handler(
                self.__rpc_room_create,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomCreateRequest,
                puppet.RoomCreateResponse,
            ),
            "/wechaty.Puppet/RoomDel": grpclib.const.Handler(
                self.__rpc_room_del,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomDelRequest,
                puppet.RoomDelResponse,
            ),
            "/wechaty.Puppet/RoomQuit": grpclib.const.Handler(
                self.__rpc_room_quit,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomQuitRequest,
                puppet.RoomQuitResponse,
            ),
            "/wechaty.Puppet/RoomTopic": grpclib.const.Handler(
                self.__rpc_room_topic,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomTopicRequest,
                puppet.RoomTopicResponse,
            ),
            "/wechaty.Puppet/RoomQRCode": grpclib.const.Handler(
                self.__rpc_room_qr_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomQrCodeRequest,
                puppet.RoomQrCodeResponse,
            ),
            "/wechaty.Puppet/RoomAnnounce": grpclib.const.Handler(
                self.__rpc_room_announce,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomAnnounceRequest,
                puppet.RoomAnnounceResponse,
            ),
            "/wechaty.Puppet/RoomMemberPayload": grpclib.const.Handler(
                self.__rpc_room_member_payload,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomMemberPayloadRequest,
                puppet.RoomMemberPayloadResponse,
            ),
            "/wechaty.Puppet/RoomMemberList": grpclib.const.Handler(
                self.__rpc_room_member_list,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomMemberListRequest,
                puppet.RoomMemberListResponse,
            ),
            "/wechaty.Puppet/RoomInvitationPayload": grpclib.const.Handler(
                self.__rpc_room_invitation_payload,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomInvitationPayloadRequest,
                puppet.RoomInvitationPayloadResponse,
            ),
            "/wechaty.Puppet/RoomInvitationAccept": grpclib.const.Handler(
                self.__rpc_room_invitation_accept,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.RoomInvitationAcceptRequest,
                puppet.RoomInvitationAcceptResponse,
            ),
            "/wechaty.Puppet/TagContactAdd": grpclib.const.Handler(
                self.__rpc_tag_contact_add,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.TagContactAddRequest,
                puppet.TagContactAddResponse,
            ),
            "/wechaty.Puppet/TagContactRemove": grpclib.const.Handler(
                self.__rpc_tag_contact_remove,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.TagContactRemoveRequest,
                puppet.TagContactRemoveResponse,
            ),
            "/wechaty.Puppet/TagContactDelete": grpclib.const.Handler(
                self.__rpc_tag_contact_delete,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.TagContactDeleteRequest,
                puppet.TagContactDeleteResponse,
            ),
            "/wechaty.Puppet/TagContactList": grpclib.const.Handler(
                self.__rpc_tag_contact_list,
                grpclib.const.Cardinality.UNARY_UNARY,
                puppet.TagContactListRequest,
                puppet.TagContactListResponse,
            ),
        }


from . import puppet
