! This automatically generated Fortran wrapper file allows codes
! written in Fortran to be called directly from C and translates all
! C-style arguments into expected Fortran-style arguments (with
! assumed size, local type declarations, etc.).


MODULE C_BALL_TREE
USE ISO_FORTRAN_ENV , ONLY : R32 => REAL32 , I64 => INT64 , I32 => INT32
USE PRUNE , ONLY : LEVEL
USE SWAP , ONLY : SWAP_I64
USE FAST_SELECT , ONLY : ARGSELECT
USE FAST_SORT , ONLY : ARGSORT
  IMPLICIT NONE


  INTERFACE
    SUBROUTINE OMP_SET_NESTED(NESTED)
      LOGICAL, INTENT(INOUT) :: NESTED
    END SUBROUTINE OMP_SET_NESTED
    SUBROUTINE OMP_SET_MAX_ACTIVE_LEVELS(MAX_LEVELS)
      INTEGER, INTENT(INOUT) :: MAX_LEVELS
    END SUBROUTINE OMP_SET_MAX_ACTIVE_LEVELS
    SUBROUTINE OMP_SET_NUM_THREADS(NUM_THREADS)
      INTEGER, INTENT(INOUT) :: NUM_THREADS
    END SUBROUTINE OMP_SET_NUM_THREADS
  
    FUNCTION OMP_GET_MAX_ACTIVE_LEVELS()
      ! Nested parallelism levels.
      INTEGER :: OMP_GET_MAX_ACTIVE_LEVELS
    END FUNCTION OMP_GET_MAX_ACTIVE_LEVELS
    FUNCTION OMP_GET_MAX_THREADS()
      ! Number of threads.
      INTEGER :: OMP_GET_MAX_THREADS
    END FUNCTION OMP_GET_MAX_THREADS
    FUNCTION OMP_GET_THREAD_NUM()
      ! Thread number.
      INTEGER :: OMP_GET_THREAD_NUM
    END FUNCTION OMP_GET_THREAD_NUM
  END INTERFACE

CONTAINS


  ! Getter and setter for MAX_COPY_BYTES.
  SUBROUTINE BALL_TREE_GET_MAX_COPY_BYTES(MAX_COPY_BYTES_LOCAL) BIND(C)
    USE BALL_TREE, ONLY: MAX_COPY_BYTES
    INTEGER(KIND=I64) :: MAX_COPY_BYTES_LOCAL
    MAX_COPY_BYTES_LOCAL = MAX_COPY_BYTES
  END SUBROUTINE BALL_TREE_GET_MAX_COPY_BYTES
  SUBROUTINE BALL_TREE_SET_MAX_COPY_BYTES(MAX_COPY_BYTES_LOCAL) BIND(C)
    USE BALL_TREE, ONLY: MAX_COPY_BYTES
    INTEGER(KIND=I64) :: MAX_COPY_BYTES_LOCAL
    MAX_COPY_BYTES = MAX_COPY_BYTES_LOCAL
  END SUBROUTINE BALL_TREE_SET_MAX_COPY_BYTES

  ! Getter and setter for NUMBER_OF_THREADS.
  SUBROUTINE BALL_TREE_GET_NUMBER_OF_THREADS(NUMBER_OF_THREADS_LOCAL) BIND(C)
    USE BALL_TREE, ONLY: NUMBER_OF_THREADS
    INTEGER(KIND=I32) :: NUMBER_OF_THREADS_LOCAL
    NUMBER_OF_THREADS_LOCAL = NUMBER_OF_THREADS
  END SUBROUTINE BALL_TREE_GET_NUMBER_OF_THREADS
  SUBROUTINE BALL_TREE_SET_NUMBER_OF_THREADS(NUMBER_OF_THREADS_LOCAL) BIND(C)
    USE BALL_TREE, ONLY: NUMBER_OF_THREADS
    INTEGER(KIND=I32) :: NUMBER_OF_THREADS_LOCAL
    NUMBER_OF_THREADS = NUMBER_OF_THREADS_LOCAL
  END SUBROUTINE BALL_TREE_SET_NUMBER_OF_THREADS

  
  SUBROUTINE C_CONFIGURE(NUM_THREADS_PRESENT, NUM_THREADS, MAX_LEVELS_PRESENT, MAX_LEVELS, NESTED_PRESENT, NESTED) BIND(C)
    USE ISO_C_BINDING, ONLY: C_BOOL
    USE BALL_TREE, ONLY: CONFIGURE
    IMPLICIT NONE
    LOGICAL(KIND=C_BOOL), INTENT(IN) :: NUM_THREADS_PRESENT
    INTEGER, INTENT(INOUT) :: NUM_THREADS
    LOGICAL(KIND=C_BOOL), INTENT(IN) :: MAX_LEVELS_PRESENT
    INTEGER, INTENT(INOUT) :: MAX_LEVELS
    LOGICAL(KIND=C_BOOL), INTENT(IN) :: NESTED_PRESENT
    LOGICAL, INTENT(INOUT) :: NESTED
  
    IF (NUM_THREADS_PRESENT) THEN
      IF (MAX_LEVELS_PRESENT) THEN
        IF (NESTED_PRESENT) THEN
          CALL CONFIGURE(NUM_THREADS=NUM_THREADS, MAX_LEVELS=MAX_LEVELS, NESTED=NESTED)
        ELSE
          CALL CONFIGURE(NUM_THREADS=NUM_THREADS, MAX_LEVELS=MAX_LEVELS)
        END IF
      ELSE
        IF (NESTED_PRESENT) THEN
          CALL CONFIGURE(NUM_THREADS=NUM_THREADS, NESTED=NESTED)
        ELSE
          CALL CONFIGURE(NUM_THREADS=NUM_THREADS)
        END IF
      END IF
    ELSE
      IF (MAX_LEVELS_PRESENT) THEN
        IF (NESTED_PRESENT) THEN
          CALL CONFIGURE(MAX_LEVELS=MAX_LEVELS, NESTED=NESTED)
        ELSE
          CALL CONFIGURE(MAX_LEVELS=MAX_LEVELS)
        END IF
      ELSE
        IF (NESTED_PRESENT) THEN
          CALL CONFIGURE(NESTED=NESTED)
        ELSE
          CALL CONFIGURE()
        END IF
      END IF
    END IF
  END SUBROUTINE C_CONFIGURE
  

  
  SUBROUTINE C_COMPUTE_SQUARE_SUMS(POINTS_DIM_1, POINTS_DIM_2, POINTS, SQ_SUMS_DIM_1, SQ_SUMS) BIND(C)
    USE BALL_TREE, ONLY: COMPUTE_SQUARE_SUMS
    IMPLICIT NONE
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: POINTS_DIM_1
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: POINTS_DIM_2
    REAL(KIND=R32), INTENT(IN), DIMENSION(POINTS_DIM_1,POINTS_DIM_2) :: POINTS
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: SQ_SUMS_DIM_1
    REAL(KIND=R32), INTENT(OUT), DIMENSION(SQ_SUMS_DIM_1) :: SQ_SUMS
  
    CALL COMPUTE_SQUARE_SUMS(POINTS, SQ_SUMS)
  END SUBROUTINE C_COMPUTE_SQUARE_SUMS
  

  
  SUBROUTINE C_BUILD_TREE(POINTS_DIM_1, POINTS_DIM_2, POINTS, SQ_SUMS_DIM_1, SQ_SUMS, RADII_DIM_1, RADII, MEDIANS_DIM_1, MEDIANS, S&
&Q_DISTS_DIM_1, SQ_DISTS, ORDER_DIM_1, ORDER, ROOT_PRESENT, ROOT, LEAF_SIZE_PRESENT, LEAF_SIZE) BIND(C)
    USE ISO_C_BINDING, ONLY: C_BOOL
    USE BALL_TREE, ONLY: BUILD_TREE
    IMPLICIT NONE
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: POINTS_DIM_1
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: POINTS_DIM_2
    REAL(KIND=R32), INTENT(INOUT), DIMENSION(POINTS_DIM_1,POINTS_DIM_2) :: POINTS
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: SQ_SUMS_DIM_1
    REAL(KIND=R32), INTENT(OUT), DIMENSION(SQ_SUMS_DIM_1) :: SQ_SUMS
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: RADII_DIM_1
    REAL(KIND=R32), INTENT(OUT), DIMENSION(RADII_DIM_1) :: RADII
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: MEDIANS_DIM_1
    REAL(KIND=R32), INTENT(OUT), DIMENSION(MEDIANS_DIM_1) :: MEDIANS
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: SQ_DISTS_DIM_1
    REAL(KIND=R32), INTENT(INOUT), DIMENSION(SQ_DISTS_DIM_1) :: SQ_DISTS
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: ORDER_DIM_1
    INTEGER(KIND=I64), INTENT(INOUT), DIMENSION(ORDER_DIM_1) :: ORDER
    LOGICAL(KIND=C_BOOL), INTENT(IN) :: ROOT_PRESENT
    INTEGER(KIND=I64), INTENT(IN) :: ROOT
    LOGICAL(KIND=C_BOOL), INTENT(IN) :: LEAF_SIZE_PRESENT
    INTEGER(KIND=I64), INTENT(IN) :: LEAF_SIZE
  
    IF (ROOT_PRESENT) THEN
      IF (LEAF_SIZE_PRESENT) THEN
        CALL BUILD_TREE(POINTS=POINTS, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, SQ_DISTS=SQ_DISTS, ORDER=ORDER, ROOT=ROOT, LE&
&AF_SIZE=LEAF_SIZE)
      ELSE
        CALL BUILD_TREE(POINTS=POINTS, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, SQ_DISTS=SQ_DISTS, ORDER=ORDER, ROOT=ROOT)
      END IF
    ELSE
      IF (LEAF_SIZE_PRESENT) THEN
        CALL BUILD_TREE(POINTS=POINTS, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, SQ_DISTS=SQ_DISTS, ORDER=ORDER, LEAF_SIZE=LEA&
&F_SIZE)
      ELSE
        CALL BUILD_TREE(POINTS=POINTS, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, SQ_DISTS=SQ_DISTS, ORDER=ORDER)
      END IF
    END IF
  END SUBROUTINE C_BUILD_TREE
  

  
  SUBROUTINE C_NEAREST(POINTS_DIM_1, POINTS_DIM_2, POINTS, K, TREE_DIM_1, TREE_DIM_2, TREE, SQ_SUMS_DIM_1, SQ_SUMS, RADII_DIM_1, RA&
&DII, MEDIANS_DIM_1, MEDIANS, ORDER_DIM_1, ORDER, LEAF_SIZE, INDICES_DIM_1, INDICES_DIM_2, INDICES, DISTS_DIM_1, DISTS_DIM_2, DISTS&
&, IWORK_DIM_1, IWORK_DIM_2, IWORK, RWORK_DIM_1, RWORK_DIM_2, RWORK, TO_SEARCH_PRESENT, TO_SEARCH, RANDOMNESS_PRESENT, RANDOMNESS) &
&BIND(C)
    USE ISO_C_BINDING, ONLY: C_BOOL
    USE BALL_TREE, ONLY: NEAREST
    IMPLICIT NONE
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: POINTS_DIM_1
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: POINTS_DIM_2
    REAL(KIND=R32), INTENT(IN), DIMENSION(POINTS_DIM_1,POINTS_DIM_2) :: POINTS
    INTEGER(KIND=I64), INTENT(IN) :: K
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: TREE_DIM_1
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: TREE_DIM_2
    REAL(KIND=R32), INTENT(IN), DIMENSION(TREE_DIM_1,TREE_DIM_2) :: TREE
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: SQ_SUMS_DIM_1
    REAL(KIND=R32), INTENT(IN), DIMENSION(SQ_SUMS_DIM_1) :: SQ_SUMS
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: RADII_DIM_1
    REAL(KIND=R32), INTENT(IN), DIMENSION(RADII_DIM_1) :: RADII
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: MEDIANS_DIM_1
    REAL(KIND=R32), INTENT(IN), DIMENSION(MEDIANS_DIM_1) :: MEDIANS
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: ORDER_DIM_1
    INTEGER(KIND=I64), INTENT(IN), DIMENSION(ORDER_DIM_1) :: ORDER
    INTEGER(KIND=I64), INTENT(IN) :: LEAF_SIZE
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: INDICES_DIM_1
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: INDICES_DIM_2
    INTEGER(KIND=I64), INTENT(OUT), DIMENSION(INDICES_DIM_1,INDICES_DIM_2) :: INDICES
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: DISTS_DIM_1
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: DISTS_DIM_2
    REAL(KIND=R32), INTENT(OUT), DIMENSION(DISTS_DIM_1,DISTS_DIM_2) :: DISTS
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: IWORK_DIM_1
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: IWORK_DIM_2
    INTEGER(KIND=I64), INTENT(INOUT), DIMENSION(IWORK_DIM_1,IWORK_DIM_2) :: IWORK
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: RWORK_DIM_1
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: RWORK_DIM_2
    REAL(KIND=R32), INTENT(INOUT), DIMENSION(RWORK_DIM_1,RWORK_DIM_2) :: RWORK
    LOGICAL(KIND=C_BOOL), INTENT(IN) :: TO_SEARCH_PRESENT
    INTEGER(KIND=I64), INTENT(IN) :: TO_SEARCH
    LOGICAL(KIND=C_BOOL), INTENT(IN) :: RANDOMNESS_PRESENT
    REAL(KIND=R32), INTENT(IN) :: RANDOMNESS
  
    IF (TO_SEARCH_PRESENT) THEN
      IF (RANDOMNESS_PRESENT) THEN
        CALL NEAREST(POINTS=POINTS, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF_SIZE&
&, INDICES=INDICES, DISTS=DISTS, IWORK=IWORK, RWORK=RWORK, TO_SEARCH=TO_SEARCH, RANDOMNESS=RANDOMNESS)
      ELSE
        CALL NEAREST(POINTS=POINTS, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF_SIZE&
&, INDICES=INDICES, DISTS=DISTS, IWORK=IWORK, RWORK=RWORK, TO_SEARCH=TO_SEARCH)
      END IF
    ELSE
      IF (RANDOMNESS_PRESENT) THEN
        CALL NEAREST(POINTS=POINTS, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF_SIZE&
&, INDICES=INDICES, DISTS=DISTS, IWORK=IWORK, RWORK=RWORK, RANDOMNESS=RANDOMNESS)
      ELSE
        CALL NEAREST(POINTS=POINTS, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF_SIZE&
&, INDICES=INDICES, DISTS=DISTS, IWORK=IWORK, RWORK=RWORK)
      END IF
    END IF
  END SUBROUTINE C_NEAREST
  

  
  SUBROUTINE C_PT_NEAREST(POINT_DIM_1, POINT, K, TREE_DIM_1, TREE_DIM_2, TREE, SQ_SUMS_DIM_1, SQ_SUMS, RADII_DIM_1, RADII, MEDIANS_&
&DIM_1, MEDIANS, ORDER_DIM_1, ORDER, LEAF_SIZE, INDICES_DIM_1, INDICES, DISTS_DIM_1, DISTS, RANDOMNESS, CHECKS_PRESENT, CHECKS, FOU&
&ND_PRESENT, FOUND, PT_SS_PRESENT, PT_SS, D_ROOT_PRESENT, D_ROOT) BIND(C)
    USE ISO_C_BINDING, ONLY: C_BOOL
    USE BALL_TREE, ONLY: PT_NEAREST
    IMPLICIT NONE
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: POINT_DIM_1
    REAL(KIND=R32), INTENT(IN), DIMENSION(POINT_DIM_1) :: POINT
    INTEGER(KIND=I64), INTENT(IN) :: K
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: TREE_DIM_1
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: TREE_DIM_2
    REAL(KIND=R32), INTENT(IN), DIMENSION(TREE_DIM_1,TREE_DIM_2) :: TREE
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: SQ_SUMS_DIM_1
    REAL(KIND=R32), INTENT(IN), DIMENSION(SQ_SUMS_DIM_1) :: SQ_SUMS
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: RADII_DIM_1
    REAL(KIND=R32), INTENT(IN), DIMENSION(RADII_DIM_1) :: RADII
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: MEDIANS_DIM_1
    REAL(KIND=R32), INTENT(IN), DIMENSION(MEDIANS_DIM_1) :: MEDIANS
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: ORDER_DIM_1
    INTEGER(KIND=I64), INTENT(IN), DIMENSION(ORDER_DIM_1) :: ORDER
    INTEGER(KIND=I64), INTENT(IN) :: LEAF_SIZE
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: INDICES_DIM_1
    INTEGER(KIND=I64), INTENT(OUT), DIMENSION(INDICES_DIM_1) :: INDICES
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: DISTS_DIM_1
    REAL(KIND=R32), INTENT(OUT), DIMENSION(DISTS_DIM_1) :: DISTS
    REAL(KIND=R32), INTENT(IN) :: RANDOMNESS
    LOGICAL(KIND=C_BOOL), INTENT(IN) :: CHECKS_PRESENT
    INTEGER(KIND=I64), INTENT(INOUT) :: CHECKS
    LOGICAL(KIND=C_BOOL), INTENT(IN) :: FOUND_PRESENT
    INTEGER(KIND=I64), INTENT(INOUT) :: FOUND
    LOGICAL(KIND=C_BOOL), INTENT(IN) :: PT_SS_PRESENT
    REAL(KIND=R32), INTENT(IN) :: PT_SS
    LOGICAL(KIND=C_BOOL), INTENT(IN) :: D_ROOT_PRESENT
    REAL(KIND=R32), INTENT(IN) :: D_ROOT
  
    IF (CHECKS_PRESENT) THEN
      IF (FOUND_PRESENT) THEN
        IF (PT_SS_PRESENT) THEN
          IF (D_ROOT_PRESENT) THEN
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, CHECKS=CHECKS, FOUND=FOUND, PT_SS=PT_SS, D_ROOT=D_ROOT)
          ELSE
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, CHECKS=CHECKS, FOUND=FOUND, PT_SS=PT_SS)
          END IF
        ELSE
          IF (D_ROOT_PRESENT) THEN
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, CHECKS=CHECKS, FOUND=FOUND, D_ROOT=D_ROOT)
          ELSE
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, CHECKS=CHECKS, FOUND=FOUND)
          END IF
        END IF
      ELSE
        IF (PT_SS_PRESENT) THEN
          IF (D_ROOT_PRESENT) THEN
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, CHECKS=CHECKS, PT_SS=PT_SS, D_ROOT=D_ROOT)
          ELSE
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, CHECKS=CHECKS, PT_SS=PT_SS)
          END IF
        ELSE
          IF (D_ROOT_PRESENT) THEN
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, CHECKS=CHECKS, D_ROOT=D_ROOT)
          ELSE
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, CHECKS=CHECKS)
          END IF
        END IF
      END IF
    ELSE
      IF (FOUND_PRESENT) THEN
        IF (PT_SS_PRESENT) THEN
          IF (D_ROOT_PRESENT) THEN
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, FOUND=FOUND, PT_SS=PT_SS, D_ROOT=D_ROOT)
          ELSE
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, FOUND=FOUND, PT_SS=PT_SS)
          END IF
        ELSE
          IF (D_ROOT_PRESENT) THEN
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, FOUND=FOUND, D_ROOT=D_ROOT)
          ELSE
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, FOUND=FOUND)
          END IF
        END IF
      ELSE
        IF (PT_SS_PRESENT) THEN
          IF (D_ROOT_PRESENT) THEN
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, PT_SS=PT_SS, D_ROOT=D_ROOT)
          ELSE
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, PT_SS=PT_SS)
          END IF
        ELSE
          IF (D_ROOT_PRESENT) THEN
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS, D_ROOT=D_ROOT)
          ELSE
            CALL PT_NEAREST(POINT=POINT, K=K, TREE=TREE, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, LEAF_SIZE=LEAF&
&_SIZE, INDICES=INDICES, DISTS=DISTS, RANDOMNESS=RANDOMNESS)
          END IF
        END IF
      END IF
    END IF
  END SUBROUTINE C_PT_NEAREST
  

  
  SUBROUTINE C_FIX_ORDER(POINTS_DIM_1, POINTS_DIM_2, POINTS, SQ_SUMS_DIM_1, SQ_SUMS, RADII_DIM_1, RADII, MEDIANS_DIM_1, MEDIANS, OR&
&DER_DIM_1, ORDER, COPY_PRESENT, COPY) BIND(C)
    USE ISO_C_BINDING, ONLY: C_BOOL
    USE BALL_TREE, ONLY: FIX_ORDER
    IMPLICIT NONE
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: POINTS_DIM_1
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: POINTS_DIM_2
    REAL(KIND=R32), INTENT(INOUT), DIMENSION(POINTS_DIM_1,POINTS_DIM_2) :: POINTS
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: SQ_SUMS_DIM_1
    REAL(KIND=R32), INTENT(INOUT), DIMENSION(SQ_SUMS_DIM_1) :: SQ_SUMS
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: RADII_DIM_1
    REAL(KIND=R32), INTENT(INOUT), DIMENSION(RADII_DIM_1) :: RADII
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: MEDIANS_DIM_1
    REAL(KIND=R32), INTENT(INOUT), DIMENSION(MEDIANS_DIM_1) :: MEDIANS
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: ORDER_DIM_1
    INTEGER(KIND=I64), INTENT(INOUT), DIMENSION(ORDER_DIM_1) :: ORDER
    LOGICAL(KIND=C_BOOL), INTENT(IN) :: COPY_PRESENT
    LOGICAL, INTENT(IN) :: COPY
  
    IF (COPY_PRESENT) THEN
      CALL FIX_ORDER(POINTS=POINTS, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER, COPY=COPY)
    ELSE
      CALL FIX_ORDER(POINTS=POINTS, SQ_SUMS=SQ_SUMS, RADII=RADII, MEDIANS=MEDIANS, ORDER=ORDER)
    END IF
  END SUBROUTINE C_FIX_ORDER
  

  
  SUBROUTINE C_BINCOUNT(INDICES_DIM_1, INDICES, USAGE_DIM_1, USAGE) BIND(C)
    USE BALL_TREE, ONLY: BINCOUNT
    IMPLICIT NONE
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: INDICES_DIM_1
    INTEGER(KIND=I64), INTENT(IN), DIMENSION(INDICES_DIM_1) :: INDICES
    INTEGER(KIND=SELECTED_INT_KIND(18)), INTENT(IN) :: USAGE_DIM_1
    INTEGER(KIND=I64), INTENT(INOUT), DIMENSION(USAGE_DIM_1) :: USAGE
  
    CALL BINCOUNT(INDICES, USAGE)
  END SUBROUTINE C_BINCOUNT
  
END MODULE C_BALL_TREE

