import typing
import clr
import os
clr.AddReference(os.path.realpath(os.path.join(os.path.dirname(__file__), "..", "..",  'lib', 'UnderAutomation.Fanuc.dll')))
from UnderAutomation.Fanuc.Ftp.Variables import VectorVariable as vector_variable

class VectorVariable:
	def __init__(self, _internal = 0):
		if(_internal == 0):
			self._instance = vector_variable()
		else:
			self._instance = _internal
	@staticmethod
	def parse(value: str) -> 'VectorVariable':
		return VectorVariable(vector_variable.Parse(value))
	@property
	def x(self) -> float:
		return self._instance.X
	@x.setter
	def x(self, value: float):
		self._instance.X = value
	@property
	def y(self) -> float:
		return self._instance.Y
	@y.setter
	def y(self, value: float):
		self._instance.Y = value
	@property
	def z(self) -> float:
		return self._instance.Z
	@z.setter
	def z(self, value: float):
		self._instance.Z = value
