import typing
import clr
import os
clr.AddReference(os.path.realpath(os.path.join(os.path.dirname(__file__), "..", "..",  'lib', 'UnderAutomation.Fanuc.dll')))
from UnderAutomation.Fanuc.Kinematics.Crx import ICrxDhmParameters as i_crx_dhm_parameters

class ICrxDhmParameters:
	def __init__(self, _internal = 0):
		if(_internal == 0):
			self._instance = i_crx_dhm_parameters()
		else:
			self._instance = _internal
	@property
	def a2(self) -> float:
		return self._instance.A2
	@property
	def d4(self) -> float:
		return self._instance.D4
	@property
	def d5(self) -> float:
		return self._instance.D5
	@property
	def d6(self) -> float:
		return self._instance.D6
