# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ytscraper', 'ytscraper.commands', 'ytscraper.helper']

package_data = \
{'': ['*']}

install_requires = \
['appdirs>=1.4.3,<2.0.0',
 'click>=7.1.1,<8.0.0',
 'google-api-python-client>=1.8.0,<2.0.0',
 'ratelimit>=2.2.1,<3.0.0',
 'toml>=0.10.0,<0.11.0']

entry_points = \
{'console_scripts': ['yt-scraper = ytscraper.app:run']}

setup_kwargs = {
    'name': 'yt-scraper',
    'version': '0.8.2',
    'description': 'Command line utility querying the YouTube API v3.',
    'long_description': '# YouTube Scraper\n> A simple command utility to extract information from the YouTube API v3 for scientific purposes.\n\n[![made-with-python](https://img.shields.io/badge/Made%20with-Python-1f425f.svg)](https://www.python.org/)\n[![License: Unlicense](https://img.shields.io/badge/license-Unlicense-blue.svg)](http://unlicense.org/)\n[![version](https://img.shields.io/pypi/v/yt-scraper)](https://pypi.org/project/yt-scraper/)\n\n![](data/header.png)\n\n## About\n\nThis Python based command line utility enables the easy extraction of information from the YouTube API (Version 3). Currently, it supports only a small subset of the API interface and focuses on extracting related videos from given starting points.\n\n\n## Installation\n\nFirst, make sure you have a recent version of [Python 3][python-url] installed.\n\nNext, install **yt-scraper** by using [pip][pip-url]:\n```sh\nsudo pip install yt-scraper\n```\n\n**Update** by adding the `--upgrade` flag:\n```sh\nsudo pip install --upgrade yt-scraper\n```\n\n**Windows** users may need to alter the command to:\n```sh\npy -m pip install --upgrade yt-scraper\n```\n\n**Mac** users may need to alter the command to:\n\n```sh\npython3 -m pip install --upgrade yt-scraper\n```\n\n### API Key\n\nIn order to use this program, you will need an official YouTube API key. \nYou can obtain one from [this][yt-console-url] page and \nuse it with the following examples by appending `-k <KEY>` to them.\n\n## Usage\nCurrently, **yt-scraper** has two commands: *search* and *config*\n\nThe first command is used to query the YouTube API, whereas the second is used to\nconfigure the default configuration.\n\nThe search command starts a video search from one or multiple given starting points. \nThese could be multiple videos orginating from a search (using *term*),\nor a provided list of video ids (using *input*), \nor just one root video (using *id* or *url*).\n\nFor example, the following command will return the first video when one searches for `cat`.\n\n```sh\n$ yt-scraper search term \'cat\'\n```\n```\n[STATUS] Result:\n Depth: 0, Rank: 0, ID: hY7m5jjJ9mM\n            Title: CATS will make you LAUGH YOUR HEAD OFF - Funny CAT compilation\n            Related Videos: []\n```\n\nOne can also provide a video id or a video url as a starting point, \nwhich is more interesting when combined with the `--max-depth` option:\n\n\n```sh\n$ yt-scraper search id \'0A2R27kCeD4\' --max-depth 2\n```\n```\n Depth: 0, Rank: 0, ID: 0A2R27kCeD4\n            Title: 🤣 Funniest 🐶 Dogs and 😻 Cats - Awesome Funny Home Animal Videos 😇\n            Related Videos: [\'pc8-8KfIW5c\']\n     Depth: 1, Rank: 0, ID: pc8-8KfIW5c\n                Title: 🦁 Funniest Animals 🐼 - Try Not To Laugh 🤣 - Funny Domestic And Wild Animals\' Life\n                Related Videos: [\'OrJMUNEyZsE\']\n         Depth: 2, Rank: 0, ID: OrJMUNEyZsE\n                    Title: Funniest Videos for Pets to Watch Compilation | Funny Pet Videos\n                    Related Videos: []\n```\n\n\nAdditionally, one can specify the number of videos \nthat should be returned on each level by utilizing the `--number` option.\nFor instance, the following command returns two related videos \nfrom a given video (specified by it\'s url) and \nadditionally one related video from each sibling:\n```sh\n$ yt-scraper search url \'https://www.youtube.com/watch?v=0A2R27kCeD4\' --depth 1 --number 2 --number 1\n```\n```\n [STATUS] Result:\n  Depth: 0, Rank: 0, ID: 0A2R27kCeD4\n             Title: 🤣 Funniest 🐶 Dogs and 😻 Cats - Awesome Funny Home Animal Videos 😇\n             Related Videos: [\'pc8-8KfIW5c\', \'tbyAuT50eu4\']\n      Depth: 1, Rank: 0, ID: pc8-8KfIW5c\n                 Title: 🦁 Funniest Animals 🐼 - Try Not To Laugh 🤣 - Funny Domestic And Wild Animals\' Life\n                 Related Videos: []\n      Depth: 1, Rank: 1, ID: tbyAuT50eu4\n                 Title: 😁 Funniest 😻 Cats and 🐶 Dogs - Awesome Funny Pet Animals 😇\n                 Related Videos: []\n```\n\nFor the sake of brevity, you can shorten `--number` to `-n` and `--depth` to\n`-d`. \n\nThere are even global commands, too! \nGlobal options are specified in front of the command and \nalter the behavior of all commands. \nThis may not sound very meaningful to you given \nthat there only two commands right now and you are right!\nBut this is likely to change in the future.\n\nFor example, to see more output during the program execution, \nspecify `--verbose` or `-v` right after `yt-scraper`:\n\n```sh\n$ yt-scraper -v search id \'0A2R27kCeD4\' --max-depth 2\n```\n\nThere are many more options that you can make use of. \nAll of them are described in the Options section. \n\nSometimes you may find yourself struggling with all the possible options.\nFortunately, there is the `config` command for all the lazy typer out there.\n\nSetting a particular default option like the output directory to `~/my_data` is as easy\nas typing\n\n```sh\n$ yt-scraper config set encoding utf-8\n```\n\nForgetful? Just double-check by typing `get` instead of `set`: \n\n```sh\n$ yt-scraper config get encoding\n```\n```\n[STATUS] The value of \'encoding\' is set to \'utf-8\'.\n```\n\n## Configuration\n\n| Search options          | Default    | Description                                                                             |\n|-------------------------|------------|------------------------------------------------------------------------------|\n| `-n`, `--number`        | 1          | Number of the videos fetched per level (can be specified several times) |\n| `-d`, `--max-depth`     | 0          | Number of recursion steps to perform.                                                   |\n| `-k`, `--api-key`       | *Required* | The API key that should be used to query the YouTube API v3.                            |\n| `-o`, `--output-dir`    | *Optional* | Path to the directory where output files are saved                                      |\n| `-f`, `--output-format` | csv        | Specifies the file format of output files.                                              |\n| `-N`, `--output-name`   | *Optional* | Specifies the file name or prefix of output files.                                      |\n| `-r`, `--region-code`   | de         | Return only videos which are unrestricted in the given region.                          |\n| `-l`, `--lang-code`     | de         | Return videos mostly relevant to a specified language.                                  |\n| `-s`, `--safe-search`   | none       | Filter sensitive or restricted videos.                                                  |\n| `-e`, `--encoding`      | utf-8      | Transform fetched text to another encoding.                                             |\n| `-u`, `--unique`        | False      | Do not process seen videos again                                                        |\n\n\n| Global options        | Default           | Description                                                                       |\n|-----------------------|-------------------|-----------------------------------------------------------------------------------|\n| `-c`, `--config-path` | *System-specific* | Specifies a configuration file. For details, see [configuration](#Configuration). |\n| `-v`, `--verbose`     | False             | Shows more output during program execution.                                       |\n| `-V`, `--version`     | *Optional*        | Shows the current program version and exits                                       |\n\nMore information can be found by adding the `--help` option to commands or\nreading the [YouTube API manual][yt-api-url].\n\nOld-fashioned people, who do not like the `config` command,\ncan manually configure the program by editing the `config.toml` file.\nIt is secretly used and altered when using the `config` command.\nEntered values are used in all future queries as long as \nthey are not overwritten by actual command line options.\n\nFor example, to always use the API key `ABCDEFGH` and a search depth of 3, \nwhere on each level one video less is returned, \njust create following configuration file:\n\n**config.toml**\n```toml\napi_key = "ABCDEFGH"\nnumber = [ 4, 3, 2, 1 ]\ndepth = 3\nverbose = true\n```\nAn example toml is included: [config.toml][config-url]\n\nThen put this file in your standard configuration folder. Typically this folder can be found at the following location:\n\n- Mac OS X: `~/Library/Application Support/YouTube Scraper`\n- Unix: `~/.config/youtube-scraper`\n- Windows: `C:\\Users\\<user>\\AppData\\Roaming\\YouTube Scraper`\n\nIf the folder does not exist, you may need to create it first.\n\n\n## Release History\n\n* 0.2.6 \n    - Added [UNLICENSE](license-url) to project\n* 0.3.0\n    - Uploaded to [PyPI][pypi-url]\n* 0.4.0\n    - New command *search*\n* 0.5.0\n    - Option `--depth` renamed to `--max-depth`\n    - Video attributes, such as title, description, channel are fetched\n    - More consistent option handling\n* 0.6.0\n    - New export feature: *csv*\n    - New command: *config*\n    - New API options: *region-code, lang-code and safe-search*\n\n* 0.7.0\n    - New `--version` option\n    - New `--encoding` option\n    - New `--export-name` option\n    - New `--unique` option\n    - New input method by importing a file or reading from stdin\n    - Added prompt when encountering an API error\n* 0.8.0\n    - New `--format sql` SQLite export\n    - New `config where` command\n    - Multiple API keys with automatic key switching is now possible\n\n## Roadmap\n\nEvery of these features is going to be a minor patch:\n\n- [X] Add node video data attributes, such as title and description.\n- [X] Add possibility to specify more than one API key to switch seamlessly.\n- [ ] Add possibility to query more than 50 videos on one level.\n- [ ] Add youtube-dl integration for downloading subtitles.\n- [ ] Add a testing suite.\n- [o] Add export functionality to CSV, SQLlite or Pandas.\n- [ ] Add more information about quota to README\n \n\n## Contributing\nIf you come across any bugs or have a suggestion, \nplease don\'t hesitate to [file an issue][git-new-issue-url].\n\nContributions in any form are welcomed. \nI will accept pull-requests if they extent **yt-scraper**\'s functionality.\n\nTo set up the development environment, \nplease install [Poetry][poetry-url] and run `poetry install` inside the project.\nA test suite will be added soon.\n\nIn general, the contribution process is somewhat like this:\n\n1. Fork it (`$ git clone https://github.com/rattletat/yt-scraper`)\n2. Create your feature branch (`$ git checkout -b feature/fooBar`)\n3. Commit your changes (`$ git commit -am \'Add some fooBar\'`)\n4. Push to the branch (`$ git push origin feature/fooBar`)\n5. Create a new Pull Request\n\n\n## Author\n**Michael Brauweiler**\n\n- Twitter: [@rattletat][me-twitter-url]\n- Email: [rattletat@posteo.me](mailto:rattletat@posteo.me)\n\n\n## License\nThis plugin is free and unemcumbered software released into the public domain. \n\nFor more information, see the included [UNLICENSE][license-url] file.\n\n<!-- Markdown link & img dfn\'s -->\n[pip-url]: https://pip.pypa.io/en/stable/\n[config-url]: data/config.toml\n[python-url]: https://www.python.org/\n[yt-console-url]: https://console.developers.google.com/\n[yt-api-url]: https://developers.google.com/youtube/v3/docs/search/list\n[git-new-issue-url]: https://github.com/rattletat/yt-scraper/issues/new\n[poetry-url]: https://github.com/python-poetry/poetry\n[pypi-url]: https://pypi.org/project/yt-scraper/\n[me-github-url]: https://github.com/rattletat\n[me-twitter-url]: https://twitter.com/m_brauweiler\n[license-url]: UNLICENSE\n',
    'author': 'Michael Brauweiler',
    'author_email': 'rattletat@posteo.me',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
