"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integration_1 = require("../integration");
/**
 * You can integrate an API method with an HTTP endpoint using the HTTP proxy
 * integration or the HTTP custom integration,.
 *
 * With the proxy integration, the setup is simple. You only need to set the
 * HTTP method and the HTTP endpoint URI, according to the backend requirements,
 * if you are not concerned with content encoding or caching.
 *
 * With the custom integration, the setup is more involved. In addition to the
 * proxy integration setup steps, you need to specify how the incoming request
 * data is mapped to the integration request and how the resulting integration
 * response data is mapped to the method response.
 */
class HttpIntegration extends integration_1.Integration {
    constructor(url, props = {}) {
        var _b;
        jsiiDeprecationWarnings._aws_cdk_aws_apigateway_HttpIntegrationProps(props);
        const proxy = (_b = props.proxy) !== null && _b !== void 0 ? _b : true;
        const method = props.httpMethod || 'GET';
        super({
            type: proxy ? integration_1.IntegrationType.HTTP_PROXY : integration_1.IntegrationType.HTTP,
            integrationHttpMethod: method,
            uri: url,
            options: props.options,
        });
    }
}
exports.HttpIntegration = HttpIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpIntegration[_a] = { fqn: "@aws-cdk/aws-apigateway.HttpIntegration", version: "1.145.0" };
//# sourceMappingURL=data:application/json;base64,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