"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaRestApi = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integrations_1 = require("./integrations");
const restapi_1 = require("./restapi");
/**
 * Defines an API Gateway REST API with AWS Lambda proxy integration.
 *
 * Use the `proxy` property to define a greedy proxy ("{proxy+}") and "ANY"
 * method from the specified path. If not defined, you will need to explicity
 * add resources and methods to the API.
 */
class LambdaRestApi extends restapi_1.RestApi {
    constructor(scope, id, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigateway_LambdaRestApiProps(props);
        if ((props.options && props.options.defaultIntegration) || props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Lambda integration is automatically defined');
        }
        super(scope, id, {
            defaultIntegration: new integrations_1.LambdaIntegration(props.handler),
            ...props.options,
            ...props,
        });
        if (props.proxy !== false) {
            this.root.addProxy();
            // Make sure users cannot call any other resource adding function
            this.root.addResource = addResourceThrows;
            this.root.addMethod = addMethodThrows;
            this.root.addProxy = addProxyThrows;
        }
    }
}
exports.LambdaRestApi = LambdaRestApi;
_a = JSII_RTTI_SYMBOL_1;
LambdaRestApi[_a] = { fqn: "@aws-cdk/aws-apigateway.LambdaRestApi", version: "1.145.0" };
function addResourceThrows() {
    throw new Error('Cannot call \'addResource\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addMethodThrows() {
    throw new Error('Cannot call \'addMethod\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addProxyThrows() {
    throw new Error('Cannot call \'addProxy\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
//# sourceMappingURL=data:application/json;base64,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