"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsRestApi = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const _1 = require(".");
const stepfunctions_1 = require("./integrations/stepfunctions");
const model_1 = require("./model");
/**
 * Defines an API Gateway REST API with a Synchrounous Express State Machine as a proxy integration.
 */
class StepFunctionsRestApi extends _1.RestApi {
    constructor(scope, id, props) {
        var _b, _c;
        jsiiDeprecationWarnings._aws_cdk_aws_apigateway_StepFunctionsRestApiProps(props);
        if (props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Step Functions integration is automatically defined');
        }
        if (props.stateMachine.node.defaultChild.stateMachineType !== sfn.StateMachineType.EXPRESS) {
            throw new Error('State Machine must be of type "EXPRESS". Please use StateMachineType.EXPRESS as the stateMachineType');
        }
        const stepfunctionsIntegration = stepfunctions_1.StepFunctionsIntegration.startExecution(props.stateMachine, {
            credentialsRole: role(scope, props),
            requestContext: props.requestContext,
            path: (_b = props.path) !== null && _b !== void 0 ? _b : true,
            querystring: (_c = props.querystring) !== null && _c !== void 0 ? _c : true,
            headers: props.headers,
        });
        super(scope, id, props);
        this.root.addMethod('ANY', stepfunctionsIntegration, {
            methodResponses: methodResponse(),
        });
    }
}
exports.StepFunctionsRestApi = StepFunctionsRestApi;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsRestApi[_a] = { fqn: "@aws-cdk/aws-apigateway.StepFunctionsRestApi", version: "1.145.0" };
/**
 * Defines the IAM Role for API Gateway with required permissions
 * to invoke a synchronous execution for the provided state machine
 *
 * @param scope
 * @param props
 * @returns Role - IAM Role
 */
function role(scope, props) {
    const roleName = 'StartSyncExecutionRole';
    const apiRole = new iam.Role(scope, roleName, {
        assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com'),
    });
    props.stateMachine.grantStartSyncExecution(apiRole);
    return apiRole;
}
/**
 * Defines the method response modelfor each HTTP code response
 * @returns methodResponse
 */
function methodResponse() {
    return [
        {
            statusCode: '200',
            responseModels: {
                'application/json': model_1.Model.EMPTY_MODEL,
            },
        },
        {
            statusCode: '400',
            responseModels: {
                'application/json': model_1.Model.ERROR_MODEL,
            },
        },
        {
            statusCode: '500',
            responseModels: {
                'application/json': model_1.Model.ERROR_MODEL,
            },
        },
    ];
}
//# sourceMappingURL=data:application/json;base64,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