# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2016-10-23 12:29
# flake8: noqa: E303
from __future__ import unicode_literals

from django.db import migrations
from django.core.management.sql import emit_post_migrate_signal


def remove_user_permission_for_moderator_group(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    try:
        # Django 1.9
        emit_post_migrate_signal(2, False, db_alias)
    except TypeError:
        # Django < 1.9
        try:
            # Django 1.8
            emit_post_migrate_signal(2, False, 'default', db_alias)
        except TypeError:  # Django < 1.8
            emit_post_migrate_signal([], 2, False, 'default', db_alias)

    Group = apps.get_model('auth.Group')
    Permission = apps.get_model('auth.Permission')


    # <- Moderator ->
    moderator_group = Group.objects.filter(name='Moderators').first()
    if moderator_group:
        change_user = Permission.objects.get(codename='change_user')
        moderator_group.permissions.remove(change_user)


class Migration(migrations.Migration):
    dependencies = [
        ('core', '0050_data_migration_promoted_articles'),
        ('contenttypes', '0002_remove_content_type_name'),
        ('wagtailcore', '0032_add_bulk_delete_page_permission'),
        ('wagtailadmin', '0001_create_admin_access_permissions'),
        ('wagtailusers', '0005_make_related_name_wagtail_specific'),
        ('sites', '0002_alter_domain_unique'),
        ('auth', '0007_alter_validators_add_error_messages'),
    ]

    operations = [
        migrations.RunPython(remove_user_permission_for_moderator_group),
    ]
