# Skills

The `-b glossary` skill enables `qary` to answer basic "what is" questions about data science for healthcare terms and concepts.

## `qary -b QA`

It can even answer general factual questions like "What is Barak Obama's Birthday?".
But if the answer isn't explicitly stated on Wikipedia somewhere it will make something up:

```
YOU: When was Barak Obama born?
qary: August 4, 1961
YOU: Who invented the perceptron?
qary: Everett Rogers
YOU: -1 #shouldbe Frank Rosenblatt
YOU: Who invented the first perceptron neural network?
qary: Gustav Kirchhoff
YOU: -1 #shouldbe Frank Rosenblatt
YOU: Where do babies come from?
qary: industrialized countries
YOU: #goodone
```

## Others

The current version of `qary` can imitate the classic therapist bot "Eliza" and carry on a relatively entertaining conversation based on lines it's read from movie scripts.
You can select any or all of these skills with command line args and the configuration file `~/qary.ini` in your user directory.

You can also expand the complicated questions that qary can answer by adding Q/A pairs to yaml text files in  `data/faq`.
We'll use that to train deep learning networks as well as actual answers if the questions are close enough to your wording in that training file.

### `qary -b your_name_here`

And soon `qary` will be able to detect your mood and carry on more meaningful conversations, to give you encouragement and emotional support.
We'll have something like this online in a couple months:

```
bot: How are you doing?
YOU: not so great
bot: I'm really sorry to hear that. What do you think about doing 10 pushups to get your blood flowing?
YOU: not so much
bot: Would you like to chat about it?
YOU: sure
bot: So what are you feeling right now? How does your body feel?
...
```

## `qary` personalities 

Travis's probabilistic conversation manager is working nicely to chose a reply from the possiblities generated by the bots:

- `qa` (`qa_bots.py`): BERT and ALBERT Wikipedia Question Answering (WikiQA reading comprehension tests)
- `glossary` (`glossary_bots.py`): definitions from glossary yml files in data/faq/glossary-*.yml
- `pattern_bots.py`: regex patterns and greeting templates
- `fuzzy_search_bots.py`: movie dialog fuzzy matching
- `parul_bots.py`: Wikipedia searches using conventional TFIDFs, like a search engine
- `time_bots.py`: A time and productivity tracker that parses your git logs and bash history
- `elastic_bots.py`: Semantic search with elasticsearch and `nboost` to find better pages for WikiQA


Here's how those bots work together:

```bash
$ bot
(nlpia) hobs@Hobsons-MacBook-Air:~/code/chatbot/qary$ bot
# 2019-11-21 12:59:05,854 WARNING:nlpia.constants:107:            <module> Starting logger in nlpia.constants...
# 100%|█████████████████████████████████████████████████████████████████████████████████████████████| 64350/64350 [00:00<00:00, 495935.48it/s]
YOU: Hi
BOT: hey there. tired of breathing?
YOU: Hello
BOT: How do you do. Please state your problem.
YOU: What is an ELIZA chatbot?
BOT: joey never told you we went out, did he?
YOU: ^[[A
BOT: I am sorry! I dont understand you
YOU: What is an ELIZA chatbot?
BOT: Does that question interest you ?
YOU: What is a chatbot?
BOT: hello barbie is an internet-connected version of the doll that uses a chatbot provided by the company toytalk, which previously used the chatbot for a range of smartphone-based characters for children.
YOU: Hello
BOT: hello.
YOU: Hello
BOT: How do you do. Please state your problem.
YOU: bye
$
```

Check out the config file in `qary.ini` or `$ bot -h` to change the default bot personalities loaded for your own personalized bot.