# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Email(pulumi.CustomResource):
    credentials: pulumi.Output[dict]
    """
    List(Resource). Configuration settings for the credentials for the email provider. For details, see Credentials.

      * `accessKeyId` (`str`) - String, Case-sensitive. AWS Access Key ID. Used only for AWS.
      * `apiKey` (`str`) - String, Case-sensitive. API Key for your email service. Will always be encrypted in our database.
      * `apiUser` (`str`) - String. API User for your email service.
      * `domain` (`str`)
      * `region` (`str`) - String. Default region. Used only for AWS, Mailgun, and SparkPost.
      * `secretAccessKey` (`str`) - String, Case-sensitive. AWS Secret Key. Will always be encrypted in our database. Used only for AWS.
      * `smtpHost` (`str`) - String. Hostname or IP address of your SMTP server. Used only for SMTP.
      * `smtpPass` (`str`) - String, Case-sensitive. SMTP password. Used only for SMTP.
      * `smtpPort` (`float`) - Integer. Port used by your SMTP server. Please avoid using port 25 if possible because many providers have limitations on this port. Used only for SMTP.
      * `smtpUser` (`str`) - String. SMTP username. Used only for SMTP.
    """
    default_from_address: pulumi.Output[str]
    """
    String. Email address to use as the sender when no other "from" address is specified.
    """
    enabled: pulumi.Output[bool]
    """
    Boolean. Indicates whether or not the email provider is enabled.
    """
    name: pulumi.Output[str]
    """
    String. Name of the email provider. Options include `mailgun`, `mandrill`, `sendgrid`, `ses`, `smtp`, and `sparkpost`.
    """
    def __init__(__self__, resource_name, opts=None, credentials=None, default_from_address=None, enabled=None, name=None, __props__=None, __name__=None, __opts__=None):
        """
        With Auth0, you can have standard welcome, password reset, and account verification email-based workflows built right into Auth0. This resource allows you to configure email providers so you can route all emails that are part of Auth0's authentication workflows through the supported high-volume email service of your choice.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_email_provider = auth0.Email("myEmailProvider",
            credentials={
                "accessKeyId": "AKIAXXXXXXXXXXXXXXXX",
                "region": "us-east-1",
                "secretAccessKey": "7e8c2148xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            },
            default_from_address="accounts@example.com",
            enabled=True)
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] credentials: List(Resource). Configuration settings for the credentials for the email provider. For details, see Credentials.
        :param pulumi.Input[str] default_from_address: String. Email address to use as the sender when no other "from" address is specified.
        :param pulumi.Input[bool] enabled: Boolean. Indicates whether or not the email provider is enabled.
        :param pulumi.Input[str] name: String. Name of the email provider. Options include `mailgun`, `mandrill`, `sendgrid`, `ses`, `smtp`, and `sparkpost`.

        The **credentials** object supports the following:

          * `accessKeyId` (`pulumi.Input[str]`) - String, Case-sensitive. AWS Access Key ID. Used only for AWS.
          * `apiKey` (`pulumi.Input[str]`) - String, Case-sensitive. API Key for your email service. Will always be encrypted in our database.
          * `apiUser` (`pulumi.Input[str]`) - String. API User for your email service.
          * `domain` (`pulumi.Input[str]`)
          * `region` (`pulumi.Input[str]`) - String. Default region. Used only for AWS, Mailgun, and SparkPost.
          * `secretAccessKey` (`pulumi.Input[str]`) - String, Case-sensitive. AWS Secret Key. Will always be encrypted in our database. Used only for AWS.
          * `smtpHost` (`pulumi.Input[str]`) - String. Hostname or IP address of your SMTP server. Used only for SMTP.
          * `smtpPass` (`pulumi.Input[str]`) - String, Case-sensitive. SMTP password. Used only for SMTP.
          * `smtpPort` (`pulumi.Input[float]`) - Integer. Port used by your SMTP server. Please avoid using port 25 if possible because many providers have limitations on this port. Used only for SMTP.
          * `smtpUser` (`pulumi.Input[str]`) - String. SMTP username. Used only for SMTP.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if credentials is None:
                raise TypeError("Missing required property 'credentials'")
            __props__['credentials'] = credentials
            if default_from_address is None:
                raise TypeError("Missing required property 'default_from_address'")
            __props__['default_from_address'] = default_from_address
            __props__['enabled'] = enabled
            __props__['name'] = name
        super(Email, __self__).__init__(
            'auth0:index/email:Email',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, credentials=None, default_from_address=None, enabled=None, name=None):
        """
        Get an existing Email resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] credentials: List(Resource). Configuration settings for the credentials for the email provider. For details, see Credentials.
        :param pulumi.Input[str] default_from_address: String. Email address to use as the sender when no other "from" address is specified.
        :param pulumi.Input[bool] enabled: Boolean. Indicates whether or not the email provider is enabled.
        :param pulumi.Input[str] name: String. Name of the email provider. Options include `mailgun`, `mandrill`, `sendgrid`, `ses`, `smtp`, and `sparkpost`.

        The **credentials** object supports the following:

          * `accessKeyId` (`pulumi.Input[str]`) - String, Case-sensitive. AWS Access Key ID. Used only for AWS.
          * `apiKey` (`pulumi.Input[str]`) - String, Case-sensitive. API Key for your email service. Will always be encrypted in our database.
          * `apiUser` (`pulumi.Input[str]`) - String. API User for your email service.
          * `domain` (`pulumi.Input[str]`)
          * `region` (`pulumi.Input[str]`) - String. Default region. Used only for AWS, Mailgun, and SparkPost.
          * `secretAccessKey` (`pulumi.Input[str]`) - String, Case-sensitive. AWS Secret Key. Will always be encrypted in our database. Used only for AWS.
          * `smtpHost` (`pulumi.Input[str]`) - String. Hostname or IP address of your SMTP server. Used only for SMTP.
          * `smtpPass` (`pulumi.Input[str]`) - String, Case-sensitive. SMTP password. Used only for SMTP.
          * `smtpPort` (`pulumi.Input[float]`) - Integer. Port used by your SMTP server. Please avoid using port 25 if possible because many providers have limitations on this port. Used only for SMTP.
          * `smtpUser` (`pulumi.Input[str]`) - String. SMTP username. Used only for SMTP.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["credentials"] = credentials
        __props__["default_from_address"] = default_from_address
        __props__["enabled"] = enabled
        __props__["name"] = name
        return Email(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

