# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.awt
from enum import IntFlag
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.awt import InvalidateStyle as InvalidateStyle
    if hasattr(InvalidateStyle, '_constants') and isinstance(InvalidateStyle._constants, dict):
        InvalidateStyle._constants['__ooo_ns__'] = 'com.sun.star.awt'
        InvalidateStyle._constants['__ooo_full_ns__'] = 'com.sun.star.awt.InvalidateStyle'
        InvalidateStyle._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global InvalidateStyleEnum
        ls = [f for f in dir(InvalidateStyle) if not callable(getattr(InvalidateStyle, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(InvalidateStyle, name)
        InvalidateStyleEnum = IntFlag('InvalidateStyleEnum', _dict)
    build_enum()
else:
    from ...lo.awt.invalidate_style import InvalidateStyle as InvalidateStyle

    class InvalidateStyleEnum(IntFlag):
        """
        Enum of Const Class InvalidateStyle

        specifies how to invalidate windows.
        """
        CHILDREN = InvalidateStyle.CHILDREN
        """
        The child windows are invalidated, too.
        """
        NOCHILDREN = InvalidateStyle.NOCHILDREN
        """
        The child windows are not invalidated.
        """
        NOERASE = InvalidateStyle.NOERASE
        """
        The invalidated area is painted with the background color/pattern.
        """
        UPDATE = InvalidateStyle.UPDATE
        """
        The invalidated area is updated immediately.
        """
        TRANSPARENT = InvalidateStyle.TRANSPARENT
        """
        The parent window is invalidated, too.
        """
        NOTRANSPARENT = InvalidateStyle.NOTRANSPARENT
        """
        The parent window is not invalidated.
        """
        NOCLIPCHILDREN = InvalidateStyle.NOCLIPCHILDREN
        """
        The area is invalidated regardless of overlapping child windows.
        """

__all__ = ['InvalidateStyle', 'InvalidateStyleEnum']
