# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.chart
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.chart import ChartSymbolType as ChartSymbolType
    if hasattr(ChartSymbolType, '_constants') and isinstance(ChartSymbolType._constants, dict):
        ChartSymbolType._constants['__ooo_ns__'] = 'com.sun.star.chart'
        ChartSymbolType._constants['__ooo_full_ns__'] = 'com.sun.star.chart.ChartSymbolType'
        ChartSymbolType._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global ChartSymbolTypeEnum
        ls = [f for f in dir(ChartSymbolType) if not callable(getattr(ChartSymbolType, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(ChartSymbolType, name)
        ChartSymbolTypeEnum = IntEnum('ChartSymbolTypeEnum', _dict)
    build_enum()
else:
    from ...lo.chart.chart_symbol_type import ChartSymbolType as ChartSymbolType

    class ChartSymbolTypeEnum(IntEnum):
        """
        Enum of Const Class ChartSymbolType

        These values specify the type of the symbol used for data points.
        
        This only applies to diagrams that use symbols like line diagrams.
        
        The default symbols are currently:
        """
        NONE = ChartSymbolType.NONE
        """
        No symbol is used.
        """
        AUTO = ChartSymbolType.AUTO
        """
        The symbol is selected automatically.
        
        The size of symbol will be dynamic and the type depends on the data row number.
        """
        BITMAPURL = ChartSymbolType.BITMAPURL
        """
        Take a Bitmap from a URL and use this as symbol.
        
        The bitmap given by the URL set in the property ChartDataPointProperties.SymbolBitmapURL is copied so that the graphic is embedded.
        """
        SYMBOL0 = ChartSymbolType.SYMBOL0
        """
        The default symbol for row 0 is used.
        """
        SYMBOL1 = ChartSymbolType.SYMBOL1
        """
        The default symbol for row 1 is used.
        """
        SYMBOL2 = ChartSymbolType.SYMBOL2
        """
        The default symbol for row 2 is used.
        """
        SYMBOL3 = ChartSymbolType.SYMBOL3
        """
        The default symbol for row 3 is used.
        """
        SYMBOL4 = ChartSymbolType.SYMBOL4
        """
        The default symbol for row 4 is used.
        """
        SYMBOL5 = ChartSymbolType.SYMBOL5
        """
        The default symbol for row 5 is used.
        """
        SYMBOL6 = ChartSymbolType.SYMBOL6
        """
        The default symbol for row 6 is used.
        """
        SYMBOL7 = ChartSymbolType.SYMBOL7
        """
        The default symbol for row 7 is used.
        """

__all__ = ['ChartSymbolType', 'ChartSymbolTypeEnum']
