# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.document
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.document import PrinterIndependentLayout as PrinterIndependentLayout
    if hasattr(PrinterIndependentLayout, '_constants') and isinstance(PrinterIndependentLayout._constants, dict):
        PrinterIndependentLayout._constants['__ooo_ns__'] = 'com.sun.star.document'
        PrinterIndependentLayout._constants['__ooo_full_ns__'] = 'com.sun.star.document.PrinterIndependentLayout'
        PrinterIndependentLayout._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global PrinterIndependentLayoutEnum
        ls = [f for f in dir(PrinterIndependentLayout) if not callable(getattr(PrinterIndependentLayout, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(PrinterIndependentLayout, name)
        PrinterIndependentLayoutEnum = IntEnum('PrinterIndependentLayoutEnum', _dict)
    build_enum()
else:
    from ...lo.document.printer_independent_layout import PrinterIndependentLayout as PrinterIndependentLayout

    class PrinterIndependentLayoutEnum(IntEnum):
        """
        Enum of Const Class PrinterIndependentLayout

        specifies whether the document printer metric is used.
        
        **since**
        
            OOo 1.1.2
        """
        DISABLED = PrinterIndependentLayout.DISABLED
        """
        use printer-dependent metrics for layout
        """
        LOW_RESOLUTION = PrinterIndependentLayout.LOW_RESOLUTION
        """
        use printer-independent metrics for layout, assuming a generic 600dpi printer
        """
        ENABLED = PrinterIndependentLayout.ENABLED
        HIGH_RESOLUTION = PrinterIndependentLayout.HIGH_RESOLUTION
        """
        use printer-independent metrics for layout, assuming a generic high-resolution printer (4800dpi)
        """

__all__ = ['PrinterIndependentLayout', 'PrinterIndependentLayoutEnum']
