# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.i18n
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.i18n import NativeNumberMode as NativeNumberMode
    if hasattr(NativeNumberMode, '_constants') and isinstance(NativeNumberMode._constants, dict):
        NativeNumberMode._constants['__ooo_ns__'] = 'com.sun.star.i18n'
        NativeNumberMode._constants['__ooo_full_ns__'] = 'com.sun.star.i18n.NativeNumberMode'
        NativeNumberMode._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global NativeNumberModeEnum
        ls = [f for f in dir(NativeNumberMode) if not callable(getattr(NativeNumberMode, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(NativeNumberMode, name)
        NativeNumberModeEnum = IntEnum('NativeNumberModeEnum', _dict)
    build_enum()
else:
    from ...lo.i18n.native_number_mode import NativeNumberMode as NativeNumberMode

    class NativeNumberModeEnum(IntEnum):
        """
        Enum of Const Class NativeNumberMode

        Constants to use with XExtendedCalendar.getDisplayString() and the XNativeNumberSupplier methods.
        
        The constants have different meanings if used with different locales. However, NATNUM1 always tries to convert to a string matching the native number mode of the corresponding locale.
        
        Where available, the corresponding Microsoft Excel (tm) DBNum number format code modifier is listed.
        
        Modifiers supported by XExtendedCalendar.getDisplayString() are marked with CAL: for the specific language and the corresponding DBNum modifier and the NatNum values used for Y/M/D are listed
        
        **since**
        
            OOo 1.1.2
        """
        NATNUM0 = NativeNumberMode.NATNUM0
        """
        Transliteration to ASCII Arabic digits.
        
        Try to convert any native number string to ASCII. If already ASCII it remains ASCII.
        """
        NATNUM1 = NativeNumberMode.NATNUM1
        """
        Transliteration in
        Chinese: Chinese lower case characters; CAL: 1/7/7 [DBNum1]
        Japanese: short Kanji characters [DBNum1]; CAL: 1/4/4 [DBNum1]
        Korean: Korean lower case characters [DBNum1]; CAL: 1/7/7 [DBNum1]
        Hebrew: Hebrew characters
        Arabic: Arabic-Indic characters
        Thai: Thai characters
        Hindi: Indic-Devanagari characters
        Odia: Odia (Oriya) characters
        Marathi: Indic-Devanagari characters
        Bengali: Bengali characters
        Punjabi: Punjabi (Gurmukhi) characters
        Gujarati: Gujarati characters
        Tamil: Tamil characters
        Telugu: Telugu characters
        Kannada: Kannada characters
        Malayalam: Malayalam characters
        Lao: Lao characters
        Tibetan: Tibetan characters
        Burmese: Burmese (Myanmar) characters
        Khmer: Khmer (Cambodian) characters
        Mongolian: Mongolian characters
        Nepali: Indic-Devanagari characters
        Dzongkha: Tibetan characters
        Farsi: East Arabic-Indic characters
        Church Slavic: Cyrillic characters.
        """
        NATNUM2 = NativeNumberMode.NATNUM2
        """
        Transliteration in
        Chinese: Chinese upper case characters; CAL: 2/8/8 [DBNum2]
        Japanese: traditional Kanji characters; CAL: 2/5/5 [DBNum2]
        Korean: Korean upper case characters [DBNum2]; CAL: 2/8/8 [DBNum2]
        Hebrew: Hebrew numbering.
        """
        NATNUM3 = NativeNumberMode.NATNUM3
        """
        Transliteration in
        Chinese: fullwidth Arabic digits; CAL: 3/3/3 [DBNum3]
        Japanese: fullwidth Arabic digits; CAL: 3/3/3 [DBNum3]
        Korean: fullwidth Arabic digits [DBNum3]; CAL: 3/3/3 [DBNum3].
        """
        NATNUM4 = NativeNumberMode.NATNUM4
        """
        Transliteration in
        Chinese: lower case text [DBNum1]
        Japanese: modern long Kanji text [DBNum2]
        Korean: formal lower case text.
        """
        NATNUM5 = NativeNumberMode.NATNUM5
        """
        Transliteration in
        Chinese: Chinese upper case text [DBNum2]
        Japanese: traditional long Kanji text [DBNum3]
        Korean: formal upper case text.
        """
        NATNUM6 = NativeNumberMode.NATNUM6
        """
        Transliteration in
        Chinese: fullwidth text [DBNum3]
        Japanese: fullwidth text
        Korean: fullwidth text.
        """
        NATNUM7 = NativeNumberMode.NATNUM7
        """
        Transliteration in
        Chinese: short lower case text
        Japanese: modern short Kanji text
        Korean: informal lower case text.
        """
        NATNUM8 = NativeNumberMode.NATNUM8
        """
        Transliteration in
        Chinese: short upper case text
        Japanese: traditional short Kanji text [DBNum4]
        Korean: informal upper case text.
        """
        NATNUM9 = NativeNumberMode.NATNUM9
        """
        Transliteration in
        Korean: Hangul characters.
        """
        NATNUM10 = NativeNumberMode.NATNUM10
        """
        Transliteration in
        Korean: formal Hangul text [DBNum4]; CAL: 9/11/11 [DBNum4].
        """
        NATNUM11 = NativeNumberMode.NATNUM11
        """
        Transliteration in
        Korean: informal Hangul text.
        """
        NATNUM12 = NativeNumberMode.NATNUM12
        """
        Transliteration to cardinal number names (one, two, three, ...), ordinal number names (first, second, third, ...), ordinal indicators (1st, 2nd, 3rd, ...), etc.
        
        Uses NatNum params string
        """

__all__ = ['NativeNumberMode', 'NativeNumberModeEnum']
