# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.sdb
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.sdb import CommandType as CommandType
    if hasattr(CommandType, '_constants') and isinstance(CommandType._constants, dict):
        CommandType._constants['__ooo_ns__'] = 'com.sun.star.sdb'
        CommandType._constants['__ooo_full_ns__'] = 'com.sun.star.sdb.CommandType'
        CommandType._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global CommandTypeEnum
        ls = [f for f in dir(CommandType) if not callable(getattr(CommandType, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(CommandType, name)
        CommandTypeEnum = IntEnum('CommandTypeEnum', _dict)
    build_enum()
else:
    from ...lo.sdb.command_type import CommandType as CommandType

    class CommandTypeEnum(IntEnum):
        """
        Enum of Const Class CommandType

        indicates the type of a command.
        """
        TABLE = CommandType.TABLE
        """
        indicates that a command contains a table name, which can be used to process a command like \"select * from tablename\".
        """
        QUERY = CommandType.QUERY
        """
        indicates that a command contains a name of a query component, which contains a certain statement.
        """
        COMMAND = CommandType.COMMAND
        """
        indicates that the command is an SQL-Statement.
        """

__all__ = ['CommandType', 'CommandTypeEnum']
