# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.text
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.text import RubyPosition as RubyPosition
    if hasattr(RubyPosition, '_constants') and isinstance(RubyPosition._constants, dict):
        RubyPosition._constants['__ooo_ns__'] = 'com.sun.star.text'
        RubyPosition._constants['__ooo_full_ns__'] = 'com.sun.star.text.RubyPosition'
        RubyPosition._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global RubyPositionEnum
        ls = [f for f in dir(RubyPosition) if not callable(getattr(RubyPosition, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(RubyPosition, name)
        RubyPositionEnum = IntEnum('RubyPositionEnum', _dict)
    build_enum()
else:
    from ...lo.text.ruby_position import RubyPosition as RubyPosition

    class RubyPositionEnum(IntEnum):
        """
        Enum of Const Class RubyPosition

        These constants define the position of ruby text.
        
        **since**
        
            LibreOffice 6.1
        """
        ABOVE = RubyPosition.ABOVE
        """
        ruby text should be above or on the right side of base text.
        """
        BELOW = RubyPosition.BELOW
        """
        ruby text should be below or on the left side of base text.
        """
        INTER_CHARACTER = RubyPosition.INTER_CHARACTER
        """
        Vertically aligned on right side of the base text in horizontal mode.
        
        This is the same as ABOVE in vertical writing mode.
        """

__all__ = ['RubyPosition', 'RubyPositionEnum']
