# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.ucb
from enum import IntFlag
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.ucb import ContentInfoAttribute as ContentInfoAttribute
    if hasattr(ContentInfoAttribute, '_constants') and isinstance(ContentInfoAttribute._constants, dict):
        ContentInfoAttribute._constants['__ooo_ns__'] = 'com.sun.star.ucb'
        ContentInfoAttribute._constants['__ooo_full_ns__'] = 'com.sun.star.ucb.ContentInfoAttribute'
        ContentInfoAttribute._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global ContentInfoAttributeEnum
        ls = [f for f in dir(ContentInfoAttribute) if not callable(getattr(ContentInfoAttribute, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(ContentInfoAttribute, name)
        ContentInfoAttributeEnum = IntFlag('ContentInfoAttributeEnum', _dict)
    build_enum()
else:
    from ...lo.ucb.content_info_attribute import ContentInfoAttribute as ContentInfoAttribute

    class ContentInfoAttributeEnum(IntFlag):
        """
        Enum of Const Class ContentInfoAttribute

        These are the possible values for ContentInfo.Attributes.
        """
        NONE = ContentInfoAttribute.NONE
        """
        No extra attributes.
        """
        INSERT_WITH_INPUTSTREAM = ContentInfoAttribute.INSERT_WITH_INPUTSTREAM
        """
        Supply an input stream with the InsertCommandArgument, when committing the new content by executing the command \"insert\" at it.
        """
        KIND_DOCUMENT = ContentInfoAttribute.KIND_DOCUMENT
        """
        The new content is of kind document.
        
        It's value for the property \"IsDocument\" will be true.
        """
        KIND_FOLDER = ContentInfoAttribute.KIND_FOLDER
        """
        The new content is of kind folder.
        
        It's value for the property \"IsFolder\" will be true.
        """
        KIND_LINK = ContentInfoAttribute.KIND_LINK
        """
        The new content is of kind link.
        
        It will support the property \"TargetURL\" ( which identifies it as a link ).
        """

__all__ = ['ContentInfoAttribute', 'ContentInfoAttributeEnum']
