# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.ui
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.ui import UIElementType as UIElementType
    if hasattr(UIElementType, '_constants') and isinstance(UIElementType._constants, dict):
        UIElementType._constants['__ooo_ns__'] = 'com.sun.star.ui'
        UIElementType._constants['__ooo_full_ns__'] = 'com.sun.star.ui.UIElementType'
        UIElementType._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global UIElementTypeEnum
        ls = [f for f in dir(UIElementType) if not callable(getattr(UIElementType, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(UIElementType, name)
        UIElementTypeEnum = IntEnum('UIElementTypeEnum', _dict)
    build_enum()
else:
    from ...lo.ui.ui_element_type import UIElementType as UIElementType

    class UIElementTypeEnum(IntEnum):
        """
        Enum of Const Class UIElementType

        determine the type of a user interface element which is controlled by a layout manager.
        
        **since**
        
            OOo 2.0
        """
        UNKNOWN = UIElementType.UNKNOWN
        """
        unknown user interface element type, which can be used as a wildcard to specify all types.
        """
        MENUBAR = UIElementType.MENUBAR
        """
        specifies a menu bar.
        """
        POPUPMENU = UIElementType.POPUPMENU
        """
        specifies a pop-up menu.
        """
        TOOLBAR = UIElementType.TOOLBAR
        """
        specifies a toolbar.
        """
        STATUSBAR = UIElementType.STATUSBAR
        """
        specifies a statusbar.
        """
        FLOATINGWINDOW = UIElementType.FLOATINGWINDOW
        """
        specifies a floating window, which can also be docked.
        """
        PROGRESSBAR = UIElementType.PROGRESSBAR
        """
        specifies a floating window, which can also be docked.
        """
        TOOLPANEL = UIElementType.TOOLPANEL
        """
        specifies a tool panel
        """
        DOCKINGWINDOW = UIElementType.DOCKINGWINDOW
        """
        specifies a window that can be docked.
        """
        COUNT = UIElementType.COUNT
        """
        specifies the number of constants.
        """

__all__ = ['UIElementType', 'UIElementTypeEnum']
