# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.awt


class FontUnderline(object):
    """
    Const Class

    These values are used to specify the kind of underlining.
    
    They may be expanded in future versions.

    See Also:
        `API FontUnderline <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1awt_1_1FontUnderline.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.FontUnderline'
    __ooo_type_name__: str = 'const'

    NONE = 0
    """
    specifies no underlining.
    """
    SINGLE = 1
    """
    specifies underlining with a single line.
    """
    DOUBLE = 2
    """
    specifies underlining with a double line.
    """
    DOTTED = 3
    """
    specifies underlining with a dotted line.
    """
    DONTKNOW = 4
    """
    The kind of underlining is not known.
    """
    DASH = 5
    """
    specifies underlining with a dashed line.
    """
    LONGDASH = 6
    """
    specifies underlining with long dashes.
    """
    DASHDOT = 7
    """
    specifies underlining with a dash and dot sequence.
    """
    DASHDOTDOT = 8
    """
    specifies underlining with a dash, dot, dot sequence.
    """
    SMALLWAVE = 9
    """
    specifies underlining with a small wave.
    """
    WAVE = 10
    """
    specifies underlining with a wave.
    """
    DOUBLEWAVE = 11
    """
    specifies underlining with a double wave.
    """
    BOLD = 12
    """
    specifies underlining with a bold line.
    """
    BOLDDOTTED = 13
    """
    specifies underlining with bold dots.
    """
    BOLDDASH = 14
    """
    specifies underlining with bold dashes.
    """
    BOLDLONGDASH = 15
    """
    specifies underlining with long bold dashes.
    """
    BOLDDASHDOT = 16
    """
    specifies underlining with a dash and dot sequence in bold.
    """
    BOLDDASHDOTDOT = 17
    """
    specifies underlining with a dash, dot, dot sequence in bold.
    """
    BOLDWAVE = 18
    """
    specifies underlining with a bold wave.
    """

__all__ = ['FontUnderline']
