# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.awt.tree
# Libre Office Version: 7.2
from ooo.oenv.env_const import UNO_NONE
from ...lang.event_object import EventObject as EventObject_a3d70b03
from ...uno.x_interface import XInterface as XInterface_8f010a43
import typing
from .x_tree_node import XTreeNode as XTreeNode_baaf0ba0


class TreeExpansionEvent(EventObject_a3d70b03):
    """
    Struct Class

    This event tells you what node is currently expanding or collapsing.

    See Also:
        `API TreeExpansionEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1awt_1_1tree_1_1TreeExpansionEvent.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt.tree'
    __ooo_full_ns__: str = 'com.sun.star.awt.tree.TreeExpansionEvent'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.awt.tree.TreeExpansionEvent'
    """Literal Constant ``com.sun.star.awt.tree.TreeExpansionEvent``"""

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = None, Node: typing.Optional[XTreeNode_baaf0ba0] = None) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            Node (XTreeNode, optional): Node value.
        """

        if isinstance(Source, TreeExpansionEvent):
            oth: TreeExpansionEvent = Source
            self.Source = oth.Source
            self.Node = oth.Node
            return

        kargs = {
            "Source": Source,
            "Node": Node,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._node = kwargs["Node"]
        inst_keys = ('Node',)
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)


    @property
    def Node(self) -> XTreeNode_baaf0ba0:
        return self._node
    
    @Node.setter
    def Node(self, value: XTreeNode_baaf0ba0) -> None:
        self._node = value


__all__ = ['TreeExpansionEvent']
