# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.bridge
# Libre Office Version: 7.2
from ooo.oenv.env_const import UNO_NONE
import typing
from ..uno.exception import Exception as Exception_85530a09
from ..uno.x_interface import XInterface as XInterface_8f010a43
from .protocol_property import ProtocolProperty as ProtocolProperty_ff280e2c

class InvalidProtocolChangeException(Exception_85530a09):
    """
    Exception Class

    Indicates, that a requested property change could not be executed by the remote counterpart.

    See Also:
        `API InvalidProtocolChangeException <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1bridge_1_1InvalidProtocolChangeException.html>`_
    """

    __ooo_ns__: str = 'com.sun.star.bridge'
    __ooo_full_ns__: str = 'com.sun.star.bridge.InvalidProtocolChangeException'
    __ooo_type_name__: str = 'exception'
    __pyunointerface__: str = 'com.sun.star.bridge.InvalidProtocolChangeException'
    __pyunostruct__: str = 'com.sun.star.bridge.InvalidProtocolChangeException'

    typeName: str = 'com.sun.star.bridge.InvalidProtocolChangeException'
    """Literal Constant ``com.sun.star.bridge.InvalidProtocolChangeException``"""

    def __init__(self, Message: typing.Optional[str] = '', Context: typing.Optional[XInterface_8f010a43] = None, invalidProperty: typing.Optional[ProtocolProperty_ff280e2c] = UNO_NONE, reason: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            invalidProperty (ProtocolProperty, optional): invalidProperty value.
            reason (int, optional): reason value.
        """
        kargs = {
            "Message": Message,
            "Context": Context,
            "invalidProperty": invalidProperty,
            "reason": reason,
        }
        if kargs["invalidProperty"] is UNO_NONE:
            kargs["invalidProperty"] = None
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._invalid_property = kwargs["invalidProperty"]
        self._reason = kwargs["reason"]
        inst_keys = ('invalidProperty', 'reason')
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)

    @property
    def invalidProperty(self) -> ProtocolProperty_ff280e2c:
        """
        The first invalid property.
        """
        return self._invalid_property
    
    @invalidProperty.setter
    def invalidProperty(self, value: ProtocolProperty_ff280e2c) -> None:
        self._invalid_property = value

    @property
    def reason(self) -> int:
        """
        Contains 1, if the property name is unknown to the thrower; or contains 2, if the property's value can't be accepted by the thrower.
        """
        return self._reason
    
    @reason.setter
    def reason(self, value: int) -> None:
        self._reason = value


__all__ = ['InvalidProtocolChangeException']

