# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.bridge.oleautomation
# Libre Office Version: 7.2
from ooo.oenv.env_const import UNO_NONE
import typing


class NamedArgument(object):
    """
    Struct Class

    represents a named argument in a call to a method of an Automation object.
    
    The Automation bridge accepts values of NamedArgument when a call to an Automation object is made. The call is done through the com.sun.star.script.XInvocation.invoke() method, which takes all arguments in a sequence of anys. Usually the order of the arguments must correspond to the order of arguments in the Automation method. By using instances of NamedArgument the arguments in the sequence can be unordered. The Automation object being called must support named arguments, otherwise the call fails.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API NamedArgument <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1bridge_1_1oleautomation_1_1NamedArgument.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.bridge.oleautomation'
    __ooo_full_ns__: str = 'com.sun.star.bridge.oleautomation.NamedArgument'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.bridge.oleautomation.NamedArgument'
    """Literal Constant ``com.sun.star.bridge.oleautomation.NamedArgument``"""

    def __init__(self, Name: typing.Optional[str] = '', Value: typing.Optional[object] = None) -> None:
        """
        Constructor

        Arguments:
            Name (str, optional): Name value.
            Value (object, optional): Value value.
        """
        super().__init__()

        if isinstance(Name, NamedArgument):
            oth: NamedArgument = Name
            self.Name = oth.Name
            self.Value = oth.Value
            return

        kargs = {
            "Name": Name,
            "Value": Value,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._name = kwargs["Name"]
        self._value = kwargs["Value"]


    @property
    def Name(self) -> str:
        """
        The name of the argument, for which NamedArgument.Value is intended.
        """
        return self._name
    
    @Name.setter
    def Name(self, value: str) -> None:
        self._name = value

    @property
    def Value(self) -> object:
        """
        The value of the argument whose name is the one as contained in the member Name.
        """
        return self._value
    
    @Value.setter
    def Value(self, value: object) -> None:
        self._value = value


__all__ = ['NamedArgument']
