# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.datatransfer
# Libre Office Version: 7.2
from ooo.oenv.env_const import UNO_NONE
import typing


class DataFlavor(object):
    """
    Struct Class

    Each instance represents the concept of a data format as it would appear on a clipboard, or during drag and drop.

    See Also:
        `API DataFlavor <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1datatransfer_1_1DataFlavor.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.datatransfer'
    __ooo_full_ns__: str = 'com.sun.star.datatransfer.DataFlavor'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.datatransfer.DataFlavor'
    """Literal Constant ``com.sun.star.datatransfer.DataFlavor``"""

    def __init__(self, MimeType: typing.Optional[str] = '', HumanPresentableName: typing.Optional[str] = '', DataType: typing.Optional[object] = None) -> None:
        """
        Constructor

        Arguments:
            MimeType (str, optional): MimeType value.
            HumanPresentableName (str, optional): HumanPresentableName value.
            DataType (object, optional): DataType value.
        """
        super().__init__()

        if isinstance(MimeType, DataFlavor):
            oth: DataFlavor = MimeType
            self.MimeType = oth.MimeType
            self.HumanPresentableName = oth.HumanPresentableName
            self.DataType = oth.DataType
            return

        kargs = {
            "MimeType": MimeType,
            "HumanPresentableName": HumanPresentableName,
            "DataType": DataType,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._mime_type = kwargs["MimeType"]
        self._human_presentable_name = kwargs["HumanPresentableName"]
        self._data_type = kwargs["DataType"]


    @property
    def MimeType(self) -> str:
        """
        The MIME content-type (type/subtype) string describing the data format of the object to transfer.
        
        MimeType must conform to Rfc2045 and Rfc2046)
        """
        return self._mime_type
    
    @MimeType.setter
    def MimeType(self, value: str) -> None:
        self._mime_type = value

    @property
    def HumanPresentableName(self) -> str:
        """
        A human presentable name for the data format.
        """
        return self._human_presentable_name
    
    @HumanPresentableName.setter
    def HumanPresentableName(self, value: str) -> None:
        self._human_presentable_name = value

    @property
    def DataType(self) -> object:
        """
        The type of the object to transfer, for example, XOutputStream.
        """
        return self._data_type
    
    @DataType.setter
    def DataType(self, value: object) -> None:
        self._data_type = value


__all__ = ['DataFlavor']
