# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.form
import typing
from abc import abstractproperty
from .form_control_model import FormControlModel as FormControlModel_e2990d22
from .x_bound_component import XBoundComponent as XBoundComponent_d4830cbf
from .x_load_listener import XLoadListener as XLoadListener_bb200bda
from .x_reset import XReset as XReset_71670917
if typing.TYPE_CHECKING:
    from ..beans.x_property_set import XPropertySet as XPropertySet_bc180bfa

class DataAwareControlModel(FormControlModel_e2990d22, XBoundComponent_d4830cbf, XLoadListener_bb200bda, XReset_71670917):
    """
    Service Class

    is an abstract service for specialized FormControlModels which are data aware and thus can be bound to a data source.
    
    The connection between a data-aware control model and a form whose data the control should display is made by parentship relations. The parent of a data-aware control model (see com.sun.star.container.XChild, inherited via the FormControlModel and FormComponent services) has always to be a com.sun.star.form.component.DataForm.
    
    **since**
    
        OOo 3.1

    See Also:
        `API DataAwareControlModel <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1form_1_1DataAwareControlModel.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.form'
    __ooo_full_ns__: str = 'com.sun.star.form.DataAwareControlModel'
    __ooo_type_name__: str = 'service'

    @abstractproperty
    def BoundField(self) -> 'XPropertySet_bc180bfa':
        """
        references to the cursor field to which the control is bound.
        
        Applies only if the form the control model belongs to is loaded and the control is valid bound. The referenced field supports the com.sun.star.sdb.Column service.
        """

    @abstractproperty
    def DataField(self) -> str:
        """
        specifies the name of the bound database field.
        
        This property makes sense in the context of the control model only. Normally, a control model is a child of a com.sun.star.form.component.DataForm, which is bound to a higher level object such as a table or query - more general, a result set.
        This member here describes the column of this result set which the control should act for.
        
        Not every control model can be bound to every database column. Usually, super services of the DataAwareControlModel restrict the column types they can be used with.
        """

    @abstractproperty
    def InputRequired(self) -> bool:
        """
        determines whether or not input into this field is required, when it is actually bound to a database field.
        
        If this property is set to FALSE, then the form runtime will not check the control/model for NULL values before submitting data to the database. Usually, if a control model is bound to a database field which cannot be NULL, and the model itself does not have a value, then the database update is prevented, showing an error message to the user. To disable this behavior on a per-control basis, use the InputRequired property.
        
        **since**
        
            OOo 3.1
        """

    @abstractproperty
    def LabelControl(self) -> 'XPropertySet_bc180bfa':
        """
        references to a control model within the same document which should be used as a label.
        
        Any user interface action which needs to refer to the control is assumed to use this property.
        A very common design method for forms is to group a data aware control with a label control, with the latter describing the content of the former. For instance, you may have a com.sun.star.form.component.TextField, which is bound to the e-mail column of your data source. Then you will probably add a com.sun.star.form.component.FixedText whose label is \"E-Mail\", and associate it with the TextField by setting it as LabelControl.
        Now if you imagine a component offering data search in a form, this component will examine the LabelControl property, find the com.sun.star.form.component.FixedText, examine it's label, and use this label to refer to the com.sun.star.form.component.TextField.
        
        When setting the property, a number of constraints apply:
        """



__all__ = ['DataAwareControlModel']

