# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.frame


class CommandGroup(object):
    """
    Const Class

    provides information about a supported command
    
    **since**
    
        OOo 2.0

    See Also:
        `API CommandGroup <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1frame_1_1CommandGroup.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.frame'
    __ooo_full_ns__: str = 'com.sun.star.frame.CommandGroup'
    __ooo_type_name__: str = 'const'

    INTERNAL = 0
    """
    specifies internal commands.
    """
    APPLICATION = 1
    """
    specifies application based commands.
    """
    VIEW = 2
    """
    specifies view specific commands.
    """
    DOCUMENT = 3
    """
    specifies document specific commands.
    """
    EDIT = 4
    """
    specifies edit specific commands.
    """
    MACRO = 5
    """
    specifies commands used by the built-in Basic.
    """
    OPTIONS = 6
    """
    specifies commands to change options.
    """
    MATH = 7
    """
    specifies math specific commands.
    """
    NAVIGATOR = 8
    """
    specifies navigate commands.
    """
    INSERT = 9
    """
    specifies insert commands.
    """
    FORMAT = 10
    """
    specifies commands that are related to formats.
    """
    TEMPLATE = 11
    """
    specifies commands that are related to templates.
    """
    TEXT = 12
    """
    specifies text specific commands.
    """
    FRAME = 13
    """
    specifies frame specific commands.
    """
    GRAPHIC = 14
    """
    specifies commands that are related to graphical data.
    """
    TABLE = 15
    """
    specifies commands that are related to tables.
    """
    ENUMERATION = 16
    """
    specifies commands that are related to bullets and numbering.
    """
    DATA = 17
    """
    specifies commands that are related to data.
    """
    SPECIAL = 18
    """
    specifies special commands.
    """
    IMAGE = 19
    """
    specifies commands that are related to images.
    """
    CHART = 20
    """
    specifies chart specific commands.
    """
    EXPLORER = 21
    """
    specifies explorer specific commands.
    """
    CONNECTOR = 22
    """
    specifies commands that are related to connectors.
    """
    MODIFY = 23
    """
    specifies commands that are related to modifications.
    """
    DRAWING = 24
    """
    specifies commands that are related to drawing.
    """
    CONTROLS = 25
    """
    specifies commands that are related to controls.
    """

__all__ = ['CommandGroup']
