# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.i18n
# Libre Office Version: 7.2
from ooo.oenv.env_const import UNO_NONE
import typing


class FormatElement(object):
    """
    Struct Class

    One number format code and its attributes, returned in a sequence by XLocaleData.getAllFormats().
    
    Contains raw data defined in the XML locale data files.

    See Also:
        `API FormatElement <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1i18n_1_1FormatElement.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.i18n'
    __ooo_full_ns__: str = 'com.sun.star.i18n.FormatElement'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.i18n.FormatElement'
    """Literal Constant ``com.sun.star.i18n.FormatElement``"""

    def __init__(self, formatCode: typing.Optional[str] = '', formatName: typing.Optional[str] = '', formatKey: typing.Optional[str] = '', formatType: typing.Optional[str] = '', formatUsage: typing.Optional[str] = '', formatIndex: typing.Optional[int] = 0, isDefault: typing.Optional[bool] = False) -> None:
        """
        Constructor

        Arguments:
            formatCode (str, optional): formatCode value.
            formatName (str, optional): formatName value.
            formatKey (str, optional): formatKey value.
            formatType (str, optional): formatType value.
            formatUsage (str, optional): formatUsage value.
            formatIndex (int, optional): formatIndex value.
            isDefault (bool, optional): isDefault value.
        """
        super().__init__()

        if isinstance(formatCode, FormatElement):
            oth: FormatElement = formatCode
            self.formatCode = oth.formatCode
            self.formatName = oth.formatName
            self.formatKey = oth.formatKey
            self.formatType = oth.formatType
            self.formatUsage = oth.formatUsage
            self.formatIndex = oth.formatIndex
            self.isDefault = oth.isDefault
            return

        kargs = {
            "formatCode": formatCode,
            "formatName": formatName,
            "formatKey": formatKey,
            "formatType": formatType,
            "formatUsage": formatUsage,
            "formatIndex": formatIndex,
            "isDefault": isDefault,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._format_code = kwargs["formatCode"]
        self._format_name = kwargs["formatName"]
        self._format_key = kwargs["formatKey"]
        self._format_type = kwargs["formatType"]
        self._format_usage = kwargs["formatUsage"]
        self._format_index = kwargs["formatIndex"]
        self._is_default = kwargs["isDefault"]


    @property
    def formatCode(self) -> str:
        """
        The format code, for example, \"YYYY-MM-DD\".
        """
        return self._format_code
    
    @formatCode.setter
    def formatCode(self, value: str) -> None:
        self._format_code = value

    @property
    def formatName(self) -> str:
        """
        A name or description that is displayed in the number formatter dialog.
        """
        return self._format_name
    
    @formatName.setter
    def formatName(self, value: str) -> None:
        self._format_name = value

    @property
    def formatKey(self) -> str:
        """
        A unique (within one locale) identifier.
        """
        return self._format_key
    
    @formatKey.setter
    def formatKey(self, value: str) -> None:
        self._format_key = value

    @property
    def formatType(self) -> str:
        """
        Type may be one of \"short\", \"medium\", \"long\".
        """
        return self._format_type
    
    @formatType.setter
    def formatType(self, value: str) -> None:
        self._format_type = value

    @property
    def formatUsage(self) -> str:
        """
        Usage category, for example, \"DATE\" or \"FIXED_NUMBER\", corresponding with KNumberFormatUsage values.
        """
        return self._format_usage
    
    @formatUsage.setter
    def formatUsage(self, value: str) -> None:
        self._format_usage = value

    @property
    def formatIndex(self) -> int:
        """
        The index used by the number formatter, predefined values corresponding with NumberFormatIndex values.
        """
        return self._format_index
    
    @formatIndex.setter
    def formatIndex(self, value: int) -> None:
        self._format_index = value

    @property
    def isDefault(self) -> bool:
        """
        If a format code is the default code of a formatType group.
        """
        return self._is_default
    
    @isDefault.setter
    def isDefault(self, value: bool) -> None:
        self._is_default = value


__all__ = ['FormatElement']
