# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.media
import typing
from abc import abstractmethod
from ..awt.x_window import XWindow as XWindow_713b0924
if typing.TYPE_CHECKING:
    from .zoom_level import ZoomLevel as ZoomLevel_99570aa5

class XPlayerWindow(XWindow_713b0924):
    """
    interacts with the media player window

    See Also:
        `API XPlayerWindow <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1media_1_1XPlayerWindow.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.media'
    __ooo_full_ns__: str = 'com.sun.star.media.XPlayerWindow'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.media.XPlayerWindow'

    @abstractmethod
    def getZoomLevel(self) -> 'ZoomLevel_99570aa5':
        """
        gets the current media ratio.
        """
    @abstractmethod
    def setPointerType(self, SystemPointerType: int) -> None:
        """
        changes the pointer for the player window.
        """
    @abstractmethod
    def setZoomLevel(self, ZoomLevel: 'ZoomLevel_99570aa5') -> bool:
        """
        changes the zoom of the media played by the window.
        """
    @abstractmethod
    def update(self) -> None:
        """
        redraws the player window
        """

__all__ = ['XPlayerWindow']

