# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.rendering
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..geometry.real_point2_d import RealPoint2D as RealPoint2D_d6e70c78
    from .fill_rule import FillRule as FillRule_bdca0be5

class XPolyPolygon2D(XInterface_8f010a43):
    """
    Generic interface for poly-polygons in 2D.
    
    **since**
    
        OOo 2.0

    See Also:
        `API XPolyPolygon2D <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1rendering_1_1XPolyPolygon2D.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.rendering'
    __ooo_full_ns__: str = 'com.sun.star.rendering.XPolyPolygon2D'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.rendering.XPolyPolygon2D'

    @abstractmethod
    def addPolyPolygon(self, position: 'RealPoint2D_d6e70c78', polyPolygon: 'XPolyPolygon2D') -> None:
        """
        Add the specified poly-polygon at the given position.
        
        One can do symbolic path construction with this method. The poly-polygons added by this method are not joined in the sense that they participate in mutual fill rule calculations like the polygons inside a single poly-polygon do. When rendering such a poly-polygon without transparency, it will look like the constituting poly-polygons rendered separately on top of another. Alas, when rendering with transparency, separate rendering will combine the alpha of overlapping areas, whereas addPolyPolygon results in constant alpha, regardless how many internal poly-polygons overlap at a single place.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
    @abstractmethod
    def getFillRule(self) -> 'FillRule_bdca0be5':
        """
        Query the rule used to determine inside and outside of the poly-polygon.
        """
    @abstractmethod
    def getNumberOfPolygonPoints(self, polygon: int) -> int:
        """
        Query number of points inside given polygon.

        Raises:
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
    @abstractmethod
    def getNumberOfPolygons(self) -> int:
        """
        Query number of polygons inside this poly-polygon.
        """
    @abstractmethod
    def isClosed(self, index: int) -> bool:
        """
        Query whether the specified polygon outline is closed.

        Raises:
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
    @abstractmethod
    def setClosed(self, index: int, closedState: bool) -> None:
        """
        Set the close state of the specified polygon outline.
        
        Use -1 as the index to affect all polygons of this poly-polygon.

        Raises:
            com.sun.star.lang.IndexOutOfBoundsException: ``IndexOutOfBoundsException``
        """
    @abstractmethod
    def setFillRule(self, fillRule: 'FillRule_bdca0be5') -> None:
        """
        Set the rule used to determine inside and outside of the poly-polygon.
        """

__all__ = ['XPolyPolygon2D']

