# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.script
# Libre Office Version: 7.2
from ooo.oenv.env_const import UNO_NONE
import typing
from ..uno.exception import Exception as Exception_85530a09
from ..uno.x_interface import XInterface as XInterface_8f010a43
from ..uno.type_class import TypeClass as TypeClass_853109f2

class CannotConvertException(Exception_85530a09):
    """
    Exception Class

    This exception is thrown to indicate that a type conversion can not be performed.

    See Also:
        `API CannotConvertException <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1script_1_1CannotConvertException.html>`_
    """

    __ooo_ns__: str = 'com.sun.star.script'
    __ooo_full_ns__: str = 'com.sun.star.script.CannotConvertException'
    __ooo_type_name__: str = 'exception'
    __pyunointerface__: str = 'com.sun.star.script.CannotConvertException'
    __pyunostruct__: str = 'com.sun.star.script.CannotConvertException'

    typeName: str = 'com.sun.star.script.CannotConvertException'
    """Literal Constant ``com.sun.star.script.CannotConvertException``"""

    def __init__(self, Message: typing.Optional[str] = '', Context: typing.Optional[XInterface_8f010a43] = None, DestinationTypeClass: typing.Optional[TypeClass_853109f2] = TypeClass_853109f2.VOID, Reason: typing.Optional[int] = 0, ArgumentIndex: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            DestinationTypeClass (TypeClass, optional): DestinationTypeClass value.
            Reason (int, optional): Reason value.
            ArgumentIndex (int, optional): ArgumentIndex value.
        """
        kargs = {
            "Message": Message,
            "Context": Context,
            "DestinationTypeClass": DestinationTypeClass,
            "Reason": Reason,
            "ArgumentIndex": ArgumentIndex,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._destination_type_class = kwargs["DestinationTypeClass"]
        self._reason = kwargs["Reason"]
        self._argument_index = kwargs["ArgumentIndex"]
        inst_keys = ('DestinationTypeClass', 'Reason', 'ArgumentIndex')
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)

    @property
    def DestinationTypeClass(self) -> TypeClass_853109f2:
        """
        This member contains the class of the type to which the value should be converted.
        """
        return self._destination_type_class
    
    @DestinationTypeClass.setter
    def DestinationTypeClass(self, value: TypeClass_853109f2) -> None:
        self._destination_type_class = value

    @property
    def Reason(self) -> int:
        """
        This member contains the reason that the conversion failed.
        
        Have a look at FailReason.
        """
        return self._reason
    
    @Reason.setter
    def Reason(self, value: int) -> None:
        self._reason = value

    @property
    def ArgumentIndex(self) -> int:
        """
        If the conversion of a method argument fails, this is the index of the value in the \"IN\" argument list.
        
        [optional]
        """
        return self._argument_index
    
    @ArgumentIndex.setter
    def ArgumentIndex(self, value: int) -> None:
        self._argument_index = value


__all__ = ['CannotConvertException']

