# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.sdbc
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .x_connection import XConnection as XConnection_a36a0b0c
    from .x_result_set import XResultSet as XResultSet_98e30aa7

class XDatabaseMetaData(XInterface_8f010a43):
    """
    provides comprehensive information about the database as a whole.
    
    Many of the methods here return lists of information in the form of com.sun.star.sdbc.XResultSet objects. You can use the normal com.sun.star.sdbc.XRow (or com.sun.star.sdb.XColumn) methods such as com.sun.star.sdbc.XRow.getString() and com.sun.star.sdbc.XRow.getInt() to retrieve the data from these XResultSets. If a given form of metadata is not available, these methods should throw a com.sun.star.sdbc.SQLException. After calling one of the getXXX() methods, one can check whether that value is NULL with the method com.sun.star.sdbc.XRow.wasNull(). In the text only \"(may be `NULL`)\" is mentioned for this case.
    
    Some of these methods take arguments that are String patterns. These arguments all have names such as fooPattern. Within a pattern String, \"%\" means match any substring of 0 or more characters, and \"_\" means match any one character. Only metadata entries matching the search pattern are returned. If a search pattern argument is set to VOID, that argument's criteria will be dropped from the search.
    
    A com.sun.star.sdbc.SQLException will be thrown if a driver does not support a metadata method. In the case of methods that return an XResultSet, either an XResultSet (which may be empty) is returned or a SQLException is thrown.

    See Also:
        `API XDatabaseMetaData <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1sdbc_1_1XDatabaseMetaData.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sdbc'
    __ooo_full_ns__: str = 'com.sun.star.sdbc.XDatabaseMetaData'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.sdbc.XDatabaseMetaData'

    @abstractmethod
    def allProceduresAreCallable(self) -> bool:
        """
        Can all the procedures returned by getProcedures be called by the current user?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def allTablesAreSelectable(self) -> bool:
        """
        Can all the tables returned by getTable be SELECTed by the current user?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def dataDefinitionCausesTransactionCommit(self) -> bool:
        """
        does a data definition statement within a transaction force the transaction to commit?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def dataDefinitionIgnoredInTransactions(self) -> bool:
        """
        is a data definition statement within a transaction ignored?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def deletesAreDetected(self, setType: int) -> bool:
        """
        indicates whether or not a visible row delete can be detected by calling com.sun.star.sdbc.XResultSet.rowDeleted().
        
        If deletesAreDetected() returns FALSE, then deleted rows are removed from the result set.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def doesMaxRowSizeIncludeBlobs(self) -> bool:
        """
        Did getMaxRowSize() include LONGVARCHAR and LONGVARBINARY blobs?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getBestRowIdentifier(self, catalog: object, schema: str, table: str, scope: int, nullable: bool) -> 'XResultSet_98e30aa7':
        """
        gets a description of a table's optimal set of columns that uniquely identifies a row.
        
        They are ordered by SCOPE.
        
        Each column description has the following columns:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getCatalogSeparator(self) -> str:
        """
        return the separator between catalog and table name

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getCatalogTerm(self) -> str:
        """
        return the database vendor's preferred term for \"catalog\"

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getCatalogs(self) -> 'XResultSet_98e30aa7':
        """
        gets the catalog names available in this database.
        
        The results are ordered by catalog name.
        
        The catalog column is:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getColumnPrivileges(self, catalog: object, schema: str, table: str, columnNamePattern: str) -> 'XResultSet_98e30aa7':
        """
        gets a description of the access rights for a table's columns.
        
        Only privileges matching the column name criteria are returned. They are ordered by COLUMN_NAME and PRIVILEGE.
        
        Each privilege description has the following columns:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getColumns(self, catalog: object, schemaPattern: str, tableNamePattern: str, columnNamePattern: str) -> 'XResultSet_98e30aa7':
        """
        gets a description of table columns available in the specified catalog.
        
        Only column descriptions matching the catalog, schema, table and column name criteria are returned. They are ordered by TABLE_SCHEM, TABLE_NAME, and ORDINAL_POSITION.
        
        Each column description has the following columns:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getConnection(self) -> 'XConnection_a36a0b0c':
        """
        retrieves the connection that produced this metadata object.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getCrossReference(self, primaryCatalog: object, primarySchema: str, primaryTable: str, foreignCatalog: object, foreignSchema: str, foreignTable: str) -> 'XResultSet_98e30aa7':
        """
        gets a description of the foreign key columns in the foreign key table that reference the primary key columns of the primary key table (describe how one table imports another's key.) This should normally return a single foreign key/primary key pair (most tables only import a foreign key from a table once.).
        
        They are ordered by FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, and KEY_SEQ.
        
        Each foreign key column description has the following columns:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getDatabaseProductName(self) -> str:
        """
        returns the name of the database product.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getDatabaseProductVersion(self) -> str:
        """
        returns the version of the database product.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getDefaultTransactionIsolation(self) -> int:
        """
        return the database default transaction isolation level.
        
        The values are defined in com.sun.star.sdbc.TransactionIsolation.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getDriverMajorVersion(self) -> int:
        """
        returns the SDBC driver major version number.
        """
    @abstractmethod
    def getDriverMinorVersion(self) -> int:
        """
        returns the SDBC driver minor version number.
        """
    @abstractmethod
    def getDriverName(self) -> str:
        """
        returns the name of the SDBC driver.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getDriverVersion(self) -> str:
        """
        returns the version number of the SDBC driver.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getExportedKeys(self, catalog: object, schema: str, table: str) -> 'XResultSet_98e30aa7':
        """
        gets a description of the foreign key columns that reference a table's primary key columns (the foreign keys exported by a table).
        
        They are ordered by FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, and KEY_SEQ.
        
        Each foreign key column description has the following columns:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getExtraNameCharacters(self) -> str:
        """
        gets all the \"extra\" characters that can be used in unquoted identifier names (those beyond a-z, A-Z, 0-9 and _).

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getIdentifierQuoteString(self) -> str:
        """
        What's the string used to quote SQL identifiers? This returns a space \" \" if identifier quoting is not supported.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getImportedKeys(self, catalog: object, schema: str, table: str) -> 'XResultSet_98e30aa7':
        """
        gets a description of the primary key columns that are referenced by a table's foreign key columns (the primary keys imported by a table).
        
        They are ordered by PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, and KEY_SEQ.
        
        Each primary key column description has the following columns:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getIndexInfo(self, catalog: object, schema: str, table: str, unique: bool, approximate: bool) -> 'XResultSet_98e30aa7':
        """
        gets a description of a table's indices and statistics.
        
        They are ordered by NON_UNIQUE, TYPE, INDEX_NAME, and ORDINAL_POSITION.
        
        Each index column description has the following columns:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxBinaryLiteralLength(self) -> int:
        """
        return the maximal number of hex characters in an inline binary literal

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxCatalogNameLength(self) -> int:
        """
        return the maximum length of a catalog name

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxCharLiteralLength(self) -> int:
        """
        return the max length for a character literal

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxColumnNameLength(self) -> int:
        """
        return the limit on column name length

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxColumnsInGroupBy(self) -> int:
        """
        return the maximum number of columns in a \"GROUP BY\" clause

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxColumnsInIndex(self) -> int:
        """
        return the maximum number of columns allowed in an index

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxColumnsInOrderBy(self) -> int:
        """
        return the maximum number of columns in an \"ORDER BY\" clause

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxColumnsInSelect(self) -> int:
        """
        return the maximum number of columns in a \"SELECT\" list

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxColumnsInTable(self) -> int:
        """
        return the maximum number of columns in a table

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxConnections(self) -> int:
        """
        return the number of active connections at a time to this database.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxCursorNameLength(self) -> int:
        """
        return the maximum cursor name length

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxIndexLength(self) -> int:
        """
        return the maximum length of an index (in bytes)

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxProcedureNameLength(self) -> int:
        """
        return the maximum length of a procedure name

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxRowSize(self) -> int:
        """
        return the maximum length of a single row.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxSchemaNameLength(self) -> int:
        """
        return the maximum length allowed for a schema name

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxStatementLength(self) -> int:
        """
        return the maximum length of a SQL statement

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxStatements(self) -> int:
        """
        return the maximal number of open active statements at one time to this database

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxTableNameLength(self) -> int:
        """
        return the maximum length of a table name

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxTablesInSelect(self) -> int:
        """
        return the maximum number of tables in a SELECT statement

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getMaxUserNameLength(self) -> int:
        """
        return the maximum length of a user name

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getNumericFunctions(self) -> str:
        """
        gets a comma-separated list of math functions.
        
        These are the X/Open CLI math function names used in the SDBC function escape clause.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getPrimaryKeys(self, catalog: object, schema: str, table: str) -> 'XResultSet_98e30aa7':
        """
        gets a description of a table's primary key columns.
        
        They are ordered by COLUMN_NAME.
        
        Each primary key column description has the following columns:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getProcedureColumns(self, catalog: object, schemaPattern: str, procedureNamePattern: str, columnNamePattern: str) -> 'XResultSet_98e30aa7':
        """
        gets a description of a catalog's stored procedure parameters and result columns.
        
        Only descriptions matching the schema, procedure and parameter name criteria are returned. They are ordered by PROCEDURE_SCHEM and PROCEDURE_NAME. Within this, the return value, if any, is first. Next are the parameter descriptions in call order. The column descriptions follow in column number order.
        
        Each row in the XResultSet is a parameter description or column description with the following fields:
        
        Note: Some databases may not return the column descriptions for a procedure. Additional columns beyond REMARKS can be defined by the database.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getProcedureTerm(self) -> str:
        """
        return the database vendor's preferred term for \"procedure\"

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getProcedures(self, catalog: object, schemaPattern: str, procedureNamePattern: str) -> 'XResultSet_98e30aa7':
        """
        Gets a description of the stored procedures available in a catalog.
        
        Only procedure descriptions matching the schema and procedure name criteria are returned. They are ordered by PROCEDURE_SCHEM, and PROCEDURE_NAME.
        
        Each procedure description has the following columns:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getSQLKeywords(self) -> str:
        """
        gets a comma-separated list of all a database's SQL keywords that are NOT also SQL92 keywords.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getSchemaTerm(self) -> str:
        """
        return the database vendor's preferred term for \"schema\"

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getSchemas(self) -> 'XResultSet_98e30aa7':
        """
        Gets the schema names available in this database.
        
        The results are ordered by schema name.
        
        The schema column is:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getSearchStringEscape(self) -> str:
        """
        gets the string that can be used to escape wildcard characters.
        
        This is the string that can be used to escape \"_\" or \"%\" in the string pattern style catalog search parameters.
        
        The \"_\" character represents any single character.
        
        The \"%\" character represents any sequence of zero or more characters.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getStringFunctions(self) -> str:
        """
        gets a comma-separated list of string functions.
        
        These are the X/Open CLI string function names used in the SDBC function escape clause.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getSystemFunctions(self) -> str:
        """
        gets a comma-separated list of system functions.
        
        These are the X/Open CLI system function names used in the SDBC function escape clause.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getTablePrivileges(self, catalog: object, schemaPattern: str, tableNamePattern: str) -> 'XResultSet_98e30aa7':
        """
        gets a description of the access rights for each table available in a catalog.
        
        Note that a table privilege applies to one or more columns in the table. It would be wrong to assume that this privilege applies to all columns (this may be TRUE for some systems but is not TRUE for all.)
        
        Only privileges matching the schema and table name criteria are returned. They are ordered by TABLE_SCHEM, TABLE_NAME, and PRIVILEGE.
        
        Each privilege description has the following columns:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getTableTypes(self) -> 'XResultSet_98e30aa7':
        """
        gets the table types available in this database.
        
        The results are ordered by table type.
        
        The table type is:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getTables(self, catalog: object, schemaPattern: str, tableNamePattern: str, types: 'typing.Tuple[str, ...]') -> 'XResultSet_98e30aa7':
        """
        gets a description of tables available in a catalog.
        
        Only table descriptions matching the catalog, schema, table name, and type criteria are returned. They are ordered by TABLE_TYPE, TABLE_SCHEM, and TABLE_NAME.
        
        Each table description has the following columns:
        
        Note: Some databases may not return information for all tables.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getTimeDateFunctions(self) -> str:
        """
        gets a comma-separated list of time and date functions.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getTypeInfo(self) -> 'XResultSet_98e30aa7':
        """
        gets a description of all the standard SQL types supported by this database.
        
        They are ordered by DATA_TYPE and then by how closely the data type maps to the corresponding SDBC SQL type.
        
        Each type description has the following columns:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getUDTs(self, catalog: object, schemaPattern: str, typeNamePattern: str, types: 'typing.Tuple[int, ...]') -> 'XResultSet_98e30aa7':
        """
        Gets a description of the user-defined types defined in a particular schema.
        
        Schema-specific UDTs may have type OBJECT, STRUCT, or DISTINCT.
        
        Only types matching the catalog, schema, type name, and type criteria are returned. They are ordered by DATA_TYPE, TYPE_SCHEM, and TYPE_NAME. The type name parameter may be a fully-qualified name. In this case, the catalog and schemaPattern parameters are ignored.
        
        Each type description has the following columns:
        
        Note: If the driver does not support UDTs, an empty result set is returned.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getURL(self) -> str:
        """
        returns the URL for the database connection

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getUserName(self) -> str:
        """
        returns the user name from this database connection.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def getVersionColumns(self, catalog: object, schema: str, table: str) -> 'XResultSet_98e30aa7':
        """
        gets a description of a table's columns that are automatically updated when any value in a row is updated.
        
        They are unordered.
        
        Each column description has the following columns:

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def insertsAreDetected(self, setType: int) -> bool:
        """
        indicates whether or not a visible row insert can be detected by calling com.sun.star.sdbc.XResultSet.rowInserted().
        
        ()

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def isCatalogAtStart(self) -> bool:
        """
        Does a catalog appear at the start of a qualified table name? (Otherwise it appears at the end)

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def isReadOnly(self) -> bool:
        """
        checks if the database in read-only mode.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def nullPlusNonNullIsNull(self) -> bool:
        """
        are concatenations between NULL and non-NULL values NULL?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def nullsAreSortedAtEnd(self) -> bool:
        """
        Are NULL values sorted at the end, regardless of sort order?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def nullsAreSortedAtStart(self) -> bool:
        """
        Are NULL values sorted at the start regardless of sort order?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def nullsAreSortedHigh(self) -> bool:
        """
        Are NULL values sorted high?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def nullsAreSortedLow(self) -> bool:
        """
        Are NULL values sorted low?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def othersDeletesAreVisible(self, setType: int) -> bool:
        """
        indicates whether deletes made by others are visible.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def othersInsertsAreVisible(self, setType: int) -> bool:
        """
        indicates whether inserts made by others are visible.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def othersUpdatesAreVisible(self, setType: int) -> bool:
        """
        indicates whether updates made by others are visible.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def ownDeletesAreVisible(self, setType: int) -> bool:
        """
        indicates whether a result set's own deletes are visible.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def ownInsertsAreVisible(self, setType: int) -> bool:
        """
        indicates whether a result set's own inserts are visible.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def ownUpdatesAreVisible(self, setType: int) -> bool:
        """
        indicates whether a result set's own updates are visible.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def storesLowerCaseIdentifiers(self) -> bool:
        """
        Does the database treat mixed case unquoted SQL identifiers as case insensitive and store them in lower case?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def storesLowerCaseQuotedIdentifiers(self) -> bool:
        """
        Does the database treat mixed case quoted SQL identifiers as case insensitive and store them in lower case?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def storesMixedCaseIdentifiers(self) -> bool:
        """
        Does the database treat mixed case unquoted SQL identifiers as case insensitive and store them in mixed case?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def storesMixedCaseQuotedIdentifiers(self) -> bool:
        """
        Does the database treat mixed case quoted SQL identifiers as case insensitive and store them in mixed case?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def storesUpperCaseIdentifiers(self) -> bool:
        """
        Does the database treat mixed case unquoted SQL identifiers as case insensitive and store them in upper case?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def storesUpperCaseQuotedIdentifiers(self) -> bool:
        """
        Does the database treat mixed case quoted SQL identifiers as case insensitive and store them in upper case?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsANSI92EntryLevelSQL(self) -> bool:
        """

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsANSI92FullSQL(self) -> bool:
        """

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsANSI92IntermediateSQL(self) -> bool:
        """

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsAlterTableWithAddColumn(self) -> bool:
        """
        support the Database \"ALTER TABLE\" with add column?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsAlterTableWithDropColumn(self) -> bool:
        """
        support the Database \"ALTER TABLE\" with drop column?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsBatchUpdates(self) -> bool:
        """
        indicates whether the driver supports batch updates.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsCatalogsInDataManipulation(self) -> bool:
        """
        Can a catalog name be used in a data manipulation statement?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsCatalogsInIndexDefinitions(self) -> bool:
        """
        Can a catalog name be used in an index definition statement?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsCatalogsInPrivilegeDefinitions(self) -> bool:
        """
        Can a catalog name be used in a privilege definition statement?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsCatalogsInProcedureCalls(self) -> bool:
        """
        Can a catalog name be used in a procedure call statement?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsCatalogsInTableDefinitions(self) -> bool:
        """
        Can a catalog name be used in a table definition statement?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsColumnAliasing(self) -> bool:
        """
        support the Database column aliasing?
        
        The SQL AS clause can be used to provide names for computed columns or to provide alias names for columns as required.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsConvert(self, fromType: int, toType: int) -> bool:
        """
        TRUE , if the Database supports the CONVERT between the given SQL types otherwise FALSE.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsCoreSQLGrammar(self) -> bool:
        """
        TRUE, if the database supports ODBC Core SQL grammar, otherwise FALSE.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsCorrelatedSubqueries(self) -> bool:
        """
        Are correlated subqueries supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsDataDefinitionAndDataManipulationTransactions(self) -> bool:
        """
        support the Database both data definition and data manipulation statements within a transaction?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsDataManipulationTransactionsOnly(self) -> bool:
        """
        are only data manipulation statements within a transaction supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsDifferentTableCorrelationNames(self) -> bool:
        """
        If table correlation names are supported, are they restricted to be different from the names of the tables?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsExpressionsInOrderBy(self) -> bool:
        """
        Are expressions in \"ORDER BY\" lists supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsExtendedSQLGrammar(self) -> bool:
        """

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsFullOuterJoins(self) -> bool:
        """

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsGroupBy(self) -> bool:
        """
        Is some form of \"GROUP BY\" clause supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsGroupByBeyondSelect(self) -> bool:
        """
        Can a \"GROUP BY\" clause add columns not in the SELECT provided it specifies all the columns in the SELECT?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsGroupByUnrelated(self) -> bool:
        """
        Can a \"GROUP BY\" clause use columns not in the SELECT?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsIntegrityEnhancementFacility(self) -> bool:
        """
        returns TRUE, if the Database supports SQL Integrity Enhancement Facility, otherwise FALSE.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsLikeEscapeClause(self) -> bool:
        """
        Is the escape character in \"LIKE\" clauses supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsLimitedOuterJoins(self) -> bool:
        """

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsMinimumSQLGrammar(self) -> bool:
        """
        TRUE, if the database supports ODBC Minimum SQL grammar, otherwise FALSE.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsMixedCaseIdentifiers(self) -> bool:
        """
        use the database \"mixed case unquoted SQL identifiers\" case sensitive.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsMixedCaseQuotedIdentifiers(self) -> bool:
        """
        Does the database treat mixed case quoted SQL identifiers as case sensitive and as a result store them in mixed case?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsMultipleResultSets(self) -> bool:
        """
        Are multiple XResultSets from a single execute supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsMultipleTransactions(self) -> bool:
        """
        Can we have multiple transactions open at once (on different connections)?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsNonNullableColumns(self) -> bool:
        """
        Can columns be defined as non-nullable?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsOpenCursorsAcrossCommit(self) -> bool:
        """
        Can cursors remain open across commits?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsOpenCursorsAcrossRollback(self) -> bool:
        """
        Can cursors remain open across rollbacks?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsOpenStatementsAcrossCommit(self) -> bool:
        """
        Can statements remain open across commits?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsOpenStatementsAcrossRollback(self) -> bool:
        """
        Can statements remain open across rollbacks?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsOrderByUnrelated(self) -> bool:
        """
        Can an \"ORDER BY\" clause use columns not in the SELECT statement?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsOuterJoins(self) -> bool:
        """

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsPositionedDelete(self) -> bool:
        """
        Is positioned DELETE supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsPositionedUpdate(self) -> bool:
        """
        Is positioned UPDATE supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsResultSetConcurrency(self, setType: int, concurrency: int) -> bool:
        """
        Does the database support the concurrency type in combination with the given result set type?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsResultSetType(self, setType: int) -> bool:
        """
        Does the database support the given result set type?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsSchemasInDataManipulation(self) -> bool:
        """
        Can a schema name be used in a data manipulation statement?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsSchemasInIndexDefinitions(self) -> bool:
        """
        Can a schema name be used in an index definition statement?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsSchemasInPrivilegeDefinitions(self) -> bool:
        """
        Can a schema name be used in a privilege definition statement?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsSchemasInProcedureCalls(self) -> bool:
        """
        Can a schema name be used in a procedure call statement?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsSchemasInTableDefinitions(self) -> bool:
        """
        Can a schema name be used in a table definition statement?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsSelectForUpdate(self) -> bool:
        """
        Is SELECT for UPDATE supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsStoredProcedures(self) -> bool:
        """
        Are stored procedure calls using the stored procedure escape syntax supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsSubqueriesInComparisons(self) -> bool:
        """
        Are subqueries in comparison expressions supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsSubqueriesInExists(self) -> bool:
        """
        Are subqueries in \"exists\" expressions supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsSubqueriesInIns(self) -> bool:
        """
        Are subqueries in \"in\" statements supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsSubqueriesInQuantifieds(self) -> bool:
        """
        Are subqueries in quantified expressions supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsTableCorrelationNames(self) -> bool:
        """
        Are table correlation names supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsTransactionIsolationLevel(self, level: int) -> bool:
        """
        Does this database support the given transaction isolation level?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsTransactions(self) -> bool:
        """
        support the Database transactions? If not, invoking the method com.sun.star.sdbc.XConnection.commit() is a noop and the isolation level is TransactionIsolation_NONE.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsTypeConversion(self) -> bool:
        """
        TRUE , if the Database supports the CONVERT function between SQL types, otherwise FALSE.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsUnion(self) -> bool:
        """
        Is SQL UNION supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def supportsUnionAll(self) -> bool:
        """
        Is SQL UNION ALL supported?

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def updatesAreDetected(self, setType: int) -> bool:
        """
        indicates whether or not a visible row update can be detected by calling the method XResultSet.rowUpdated.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def usesLocalFilePerTable(self) -> bool:
        """
        use the database one local file to save for each table.

        Raises:
            SQLException: ``SQLException``
        """
    @abstractmethod
    def usesLocalFiles(self) -> bool:
        """
        use the database local files to save the tables.

        Raises:
            SQLException: ``SQLException``
        """

__all__ = ['XDatabaseMetaData']

