# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.sheet
import typing
from abc import abstractproperty
from ..container.x_named import XNamed as XNamed_a6520b08
from ..drawing.x_draw_page_supplier import XDrawPageSupplier as XDrawPageSupplier_1a030eab
from .scenario import Scenario as Scenario_8f730a55
from .sheet_cell_range import SheetCellRange as SheetCellRange_d4540c87
from .x_cell_range_movement import XCellRangeMovement as XCellRangeMovement_9730e31
from .x_data_pilot_tables_supplier import XDataPilotTablesSupplier as XDataPilotTablesSupplier_672a10aa
from .x_external_sheet_name import XExternalSheetName as XExternalSheetName_bf60e36
from .x_print_areas import XPrintAreas as XPrintAreas_b0470b72
from .x_scenarios_supplier import XScenariosSupplier as XScenariosSupplier_c9d0e74
from .x_sheet_annotations_supplier import XSheetAnnotationsSupplier as XSheetAnnotationsSupplier_7c1b1154
from .x_sheet_auditing import XSheetAuditing as XSheetAuditing_d47f0ca7
from .x_sheet_linkable import XSheetLinkable as XSheetLinkable_d4620c94
from .x_sheet_outline import XSheetOutline as XSheetOutline_c8760c52
from .x_sheet_page_break import XSheetPageBreak as XSheetPageBreak_e0780cd4
from .x_spreadsheet import XSpreadsheet as XSpreadsheet_bc910bf1
from ..table.x_table_charts_supplier import XTableChartsSupplier as XTableChartsSupplier_26700f09
from ..util.x_protectable import XProtectable as XProtectable_b17f0b93
if typing.TYPE_CHECKING:
    from .x_conditional_formats import XConditionalFormats as XConditionalFormats_1ab20ec9
    from ..util.color import Color as Color_68e908c5

class Spreadsheet(Scenario_8f730a55, SheetCellRange_d4540c87, XNamed_a6520b08, XDrawPageSupplier_1a030eab, XCellRangeMovement_9730e31, XDataPilotTablesSupplier_672a10aa, XExternalSheetName_bf60e36, XPrintAreas_b0470b72, XScenariosSupplier_c9d0e74, XSheetAnnotationsSupplier_7c1b1154, XSheetAuditing_d47f0ca7, XSheetLinkable_d4620c94, XSheetOutline_c8760c52, XSheetPageBreak_e0780cd4, XSpreadsheet_bc910bf1, XTableChartsSupplier_26700f09, XProtectable_b17f0b93):
    """
    Service Class

    represents a complete spreadsheet in a spreadsheet document.
    
    This service extents the service SheetCellRange. A spreadsheet is nothing else than a cell range with extended functionality.
    
    **since**
    
        OOo 3.0

    See Also:
        `API Spreadsheet <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1sheet_1_1Spreadsheet.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.Spreadsheet'
    __ooo_type_name__: str = 'service'

    @abstractproperty
    def AutomaticPrintArea(self) -> bool:
        """
        specifies whether the sheet has an automatic print area.
        
        The automatic print area is used to print a sheet without explicit print areas, also if other sheets have print areas.
        
        If the property is true, and there are print areas on other sheets, the used area of this sheet is also printed.
        
        If the property is false, and there are print areas on other sheets, only these specified print areas are printed.
        
        If there are no print areas on the other sheets it does not matter whether property is true or false.
        
        This property can only be true, if there are no print areas given on this sheet. If the property is set to true the print areas of this sheet will be removed.
        """

    @abstractproperty
    def ConditionalFormats(self) -> 'XConditionalFormats_1ab20ec9':
        """
        specifies all conditional formats of that sheet
        """

    @abstractproperty
    def IsVisible(self) -> bool:
        """
        specifies if the sheet is visible.
        """

    @abstractproperty
    def PageStyle(self) -> str:
        """
        specifies the page style of the sheet.
        """

    @abstractproperty
    def TabColor(self) -> 'Color_68e908c5':
        """
        specifies the color of the sheet tab, if any.
        """

    @abstractproperty
    def TableLayout(self) -> int:
        """
        specifies the direction of the columns in the spreadsheet.
        
        Possible values are com.sun.star.text.WritingMode2.LR_TB to order the columns from left to right, and com.sun.star.text.WritingMode2.RL_TB to order the columns from right to left.
        """



__all__ = ['Spreadsheet']

