# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.sheet
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .data_pilot_field_filter import DataPilotFieldFilter as DataPilotFieldFilter_271e0eed
    from .data_result import DataResult as DataResult_a47d0b1a

class XDataPilotResults(XInterface_8f010a43):
    """
    provides access to a table of results of a data pilot source.
    
    These results are used to fill the data area of a data pilot table.

    See Also:
        `API XDataPilotResults <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1sheet_1_1XDataPilotResults.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.XDataPilotResults'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.sheet.XDataPilotResults'

    @abstractmethod
    def getFilteredResults(self, aFilters: 'typing.Tuple[DataPilotFieldFilter_271e0eed, ...]') -> 'typing.Tuple[float, ...]':
        """
        """
    @abstractmethod
    def getResults(self) -> 'typing.Tuple[typing.Tuple[DataResult_a47d0b1a, ...], ...]':
        """
        returns the result array.
        
        The outer sequence contains the value rows. The inner sequences contain the values for one row.
        """

__all__ = ['XDataPilotResults']

