# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.sheet
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43

class XViewSplitable(XInterface_8f010a43):
    """
    enables a SpreadsheetView to split the view.
    
    .. deprecated::
    
        Class is deprecated.

    See Also:
        `API XViewSplitable <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1sheet_1_1XViewSplitable.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.XViewSplitable'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.sheet.XViewSplitable'

    @abstractmethod
    def getIsWindowSplit(self) -> bool:
        """
        returns TRUE if the view is split into individual panes.
        
        Only one of XViewSplitable.getIsWindowSplit() and XViewFreezable.hasFrozenPanes() can be TRUE.
        """
    @abstractmethod
    def getSplitColumn(self) -> int:
        """
        returns the column before which the view is split.
        """
    @abstractmethod
    def getSplitHorizontal(self) -> int:
        """
        returns the horizontal position in pixels where the view is split.
        """
    @abstractmethod
    def getSplitRow(self) -> int:
        """
        returns the row before which the view is split.
        """
    @abstractmethod
    def getSplitVertical(self) -> int:
        """
        returns the vertical position in pixels where the view is split.
        """
    @abstractmethod
    def splitAtPosition(self, nPixelX: int, nPixelY: int) -> None:
        """
        splits the view at the specified position.
        
        To split only horizontally, specify nPixelY as 0. To split only vertically, specify nPixelX as 0.
        """

__all__ = ['XViewSplitable']

